/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@StepMetadata(name="wait")
@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aq\t\u0001B\u0001B\u0003%a\u0007C\u0003I\u0001\u0011\u0005\u0011\nC\u0003I\u0001\u0011\u0005q\nC\u0003I\u0001\u0011\u0005\u0001\u000bC\u0004]\u0001\t\u0007IQB/\t\r\u0001\u0004\u0001\u0015!\u0004_\u0011\u001d\t\u0007A1A\u0005\n\tDaa\u0019\u0001!\u0002\u00131\u0004bB7\u0001\u0001\u0004%I\u0001\u001d\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0011\u0019I\b\u0001)Q\u0005u!9q\u0010\u0001b\u0001\n\u0013\u0011\u0007bBA\u0001\u0001\u0001\u0006IA\u000e\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0001C\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005U\u0001bCA\r\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bAq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA,\u0001\u0011\u0005\u0013\u0011\f\u0002\t/\u0006LGo\u0015;fa*\u0011!dG\u0001\u0006gR,\u0007o\u001d\u0006\u00039u\ta\u0001\u001d7vO&t'B\u0001\u0010 \u0003!!W\r\u001d7ps&$(B\u0001\u0011\"\u0003%AXMY5bY\u0006\u00147OC\u0001#\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Q%\f\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019y%M[3diB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\ng\u0006$X\r\u001c7ji\u0016T!AM\u0010\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u00025_\tq1+\u0019;fY2LG/Z!xCJ,\u0017!C:uKB|%\u000fZ3s!\t1s'\u0003\u00029O\t9\u0011J\u001c;fO\u0016\u0014\u0018aD:uKB$Um]2sSB$\u0018n\u001c8\u0011\u0005m\"eB\u0001\u001fC!\ti\u0004)D\u0001?\u0015\ty4%\u0001\u0004=e>|GO\u0010\u0006\u0002\u0003\u0006)1oY1mC&\u00111\tQ\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D\u0001\u0006\tr/Y5u)&lW-\u00138TK\u000e|g\u000eZ:\u0002\rqJg.\u001b;?)\u0011QE*\u0014(\u0011\u0005-\u0003Q\"A\r\t\u000bU\"\u0001\u0019\u0001\u001c\t\u000be\"\u0001\u0019\u0001\u001e\t\u000b\u001d#\u0001\u0019\u0001\u001c\u0015\u0003)#RAS)S'RCQ!\u000e\u0004A\u0002YBQ!\u000f\u0004A\u0002iBQa\u0012\u0004A\u0002YBQ!\u0016\u0004A\u0002Y\u000bA\u0001[8tiB\u0011qKW\u0007\u00021*\u0011\u0011lG\u0001\n_Z,'\u000f\u001e5fe\u0016L!a\u0017-\u0003\t!{7\u000f^\u0001\u0011'\u0016\u001buJ\u0014#T?R{ul\u0015'F\u000bB+\u0012AX\b\u0002?v\t!\"A\tT\u000b\u000e{e\nR*`)>{6\u000bT#F!\u0002\nqa]3d_:$7/F\u00017\u0003!\u0019XmY8oIN\u0004\u0003\u0006\u0002\u0006f[:\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u000bI,H.Z:\u000b\u0005)\\\u0012aA1qS&\u0011An\u001a\u0002\u000e'R,\u0007\u000fU1sC6,G/\u001a:\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002_\u0006Y3+Z2p]\u0012\u001c\b\u0005\u001e5bi\u0002\"\b.[:!gR,\u0007\u000f\t9bkN,\u0007\u0005\u001d7b]\u0002*\u00070Z2vi&|g.F\u0001;\u0003=!Wm]2sSB$\u0018n\u001c8`I\u0015\fHCA:x!\t!X/D\u0001A\u0013\t1\bI\u0001\u0003V]&$\bb\u0002=\r\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0014\u0001\u00043fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003FB\u0007f[nlh0I\u0001}\u0003-#Um]2sSB$\u0018n\u001c8!_\u001a\u0004C\u000f[5tAM$X\r\u001d\u0017!CN\u0004\u0013\u000e\u001e\u0011tQ>,H\u000e\u001a\u0011baB,\u0017M\u001d\u0011j]\u0002:WM\\3sCR,G\r\t3fa2|\u00170\\3oi\u0002\u0002H.\u00198t\u0003)\u0019\u0017\r\\2vY\u0006$X\rZ\r\u0002\u0003\u0005)qN\u001d3fe\u00061qN\u001d3fe\u0002BSaD3n\u0003\u000b\t#!a\u0002\u00027\u0015CXmY;uS>t\u0007e\u001c:eKJ\u0004sN\u001a\u0011uQ\u0016\u00043\u000f^3q\u0003%\u0019wN\u001c;bS:,'/\u0006\u0002\u0002\u000eA\u0019q+a\u0004\n\u0007\u0005E\u0001LA\u0007I_N$8i\u001c8uC&tWM]\u0001\u000eG>tG/Y5oKJ|F%Z9\u0015\u0007M\f9\u0002\u0003\u0005y#\u0005\u0005\t\u0019AA\u0007\u0003)\u0019wN\u001c;bS:,'\u000fI\u0001\u0010I>\u0004vn\u001d;D_:\u001cHO];diR\u00191/a\b\t\u000f\u0005\u00052\u00031\u0001\u0002$\u0005\u00191\r\u001e=\u0011\u0007\u0019\f)#C\u0002\u0002(\u001d\u0014\u0001d\u0015;faB{7\u000f^\"p]N$(/^2u\u0007>tG/\u001a=uQ\r\u0019\u00121\u0006\t\u0004M\u00065\u0012bAA\u0018O\n\t\"+\u001e7f!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002\u0011\u001d,Go\u0014:eKJ$\"!!\u000e\u0011\u0007Q\f9$C\u0002\u0002:\u0001\u00131!\u00138u\u000399W\r\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$\u0012AO\u0001\bKb,7-\u001e;f)\u0011\t\u0019%a\u0014\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013j\u0003\u00111Gn\\<\n\t\u00055\u0013q\t\u0002\r'R,\u0007/\u0012=ji\u000e{G-\u001a\u0005\b\u0003C1\u0002\u0019AA)!\u0011\t)%a\u0015\n\t\u0005U\u0013q\t\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fAbZ3u'\u0006$X\r\u001c7ji\u0016$\"!a\u0017\u0011\u00079\ni&C\u0002\u0002`=\u0012\u0011bU1uK2d\u0017\u000e^3)\u000f\u0001\t\u0019'!\u001b\u0002lA\u0019a-!\u001a\n\u0007\u0005\u001dtM\u0001\u0007Ti\u0016\u0004X*\u001a;bI\u0006$\u0018-\u0001\u0003oC6,\u0017EAA7\u0003\u00119\u0018-\u001b;")
public class WaitStep
implements SatelliteAware {
    @StepParameter(description="Seconds that this step pause plan execution")
    private final Integer seconds;
    @StepParameter(description="Description of this step, as it should appear in generated deployment plans", calculated=true)
    private String description;
    @StepParameter(description="Execution order of the step")
    private final Integer order;
    private HostContainer container;

    private final int SECONDS_TO_SLEEP() {
        return 10;
    }

    private Integer seconds() {
        return this.seconds;
    }

    private String description() {
        return this.description;
    }

    private void description_$eq(String x$1) {
        this.description = x$1;
    }

    private Integer order() {
        return this.order;
    }

    private HostContainer container() {
        return this.container;
    }

    private void container_$eq(HostContainer x$1) {
        this.container = x$1;
    }

    @RulePostConstruct
    private void doPostConstruct(StepPostConstructContext ctx) {
        if (this.description() == null || this.description().isEmpty()) {
            this.description_$eq("Waiting for " + this.seconds() + " seconds");
            return;
        }
    }

    public int getOrder() {
        return Predef$.MODULE$.Integer2int(this.order());
    }

    public String getDescription() {
        return this.description();
    }

    public StepExitCode execute(ExecutionContext ctx) {
        int sleepIntervals = Predef$.MODULE$.Integer2int(this.seconds()) / 10;
        int remainingSeconds = Predef$.MODULE$.Integer2int(this.seconds()) % 10;
        ctx.logOutput(this.getDescription());
        try {
            ObjectRef secondsCountDown = ObjectRef.create((Object)this.seconds());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sleepIntervals).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                ctx.logOutput("Time remaining " + (Integer)secondsCountDown$1.elem + " seconds.");
                Thread.sleep(10000L);
                secondsCountDown$1.elem = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)secondsCountDown$1.elem) - 10);
            });
            if (remainingSeconds > 0) {
                ctx.logOutput("Time remaining " + remainingSeconds + " seconds.");
                Thread.sleep(remainingSeconds * 1000);
            }
            ctx.logOutput("Wait complete.");
        }
        catch (InterruptedException interruptedException) {
            ctx.logOutput("Wait interrupted.");
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }
        return StepExitCode.SUCCESS;
    }

    public Satellite getSatellite() {
        return (Satellite)Option$.MODULE$.apply((Object)this.container()).map((Function1 & Serializable)x$3 -> x$3.getHost().getSatellite()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public WaitStep(Integer stepOrder, String stepDescription, Integer waitTimeInSeconds) {
        this.seconds = waitTimeInSeconds;
        this.description = stepDescription;
        this.order = stepOrder;
    }

    public WaitStep() {
        this(null, null, null);
    }

    public WaitStep(Integer stepOrder, String stepDescription, Integer waitTimeInSeconds, Host host) {
        this(stepOrder, stepDescription, waitTimeInSeconds);
        this.container_$eq((HostContainer)host);
    }
}

