package com.xebialabs.deployit.plugin.delegates

import java.util.{List => JList, Map => JMap}

import com.xebialabs.deployit.plugin.api.creator.CreatorContext
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Delegate, Parameters}
import com.xebialabs.deployit.plugin.context.JythonCreatorContext
import com.xebialabs.deployit.plugin.steps.JythonStep
import com.xebialabs.platform.script.jython.{ConsumerWriter, JythonContext, ScriptContextUtils, ScriptSource, Syntactic}
import com.xebialabs.xlplatform.script.jython.JythonSugarDiscovery
import com.xebialabs.platform.script.jython.DeployJythonSupport

import scala.jdk.CollectionConverters._

object JythonDelegate {

  val DEFAULT_CONTROL_TASK_STEP_ORDER = 1

  @Delegate(name = "jythonScript")
  def jythonScriptDelegate(item: ConfigurationItem, name: String, args: JMap[String, String], params: Parameters): JList[Step] = {
    require(args.containsKey("script"), s"No script defined for control task [$name] of [$item].")
    val script: String = args.get("script")
    val step: JythonStep = new JythonStep
    step.setOrder(DEFAULT_CONTROL_TASK_STEP_ORDER)
    step.setScriptPath(script)
    if (args.containsKey("preview-script")) {
      step.setPreviewScriptPath(args.get("preview-script"))
    }
    if (args.containsKey("description")) {
      step.setDescription(args.get("description"))
    } else {
      step.setDescription(s"Executing control task $name on ${item.getId}")
    }
    step.getJythonContext.put("params", params)
    step.getJythonContext.put("args", args)
    step.getJythonContext.put("thisCi", item)
    List[Step](step).asJava
  }

  @Delegate(use = Delegate.Use.CREATOR, name = "jythonScript")
  def jythonScriptCreatorDelegate(context: CreatorContext, args: JMap[String, String]): Unit = {
    if (args.containsKey("script") && args.get("script").nonEmpty) {
      val jythonCreatorContext = new JythonCreatorContext(context)
      implicit val jythonContext: JythonContext = createJythonContext(jythonCreatorContext,
        Map("context" -> jythonCreatorContext, "thisCi" -> jythonCreatorContext.getThisCI))
      new DeployJythonSupport {}.executeScript(ScriptSource.byResource(args.get("script")))
    }
  }

  private def createJythonContext(jythonCreatorContext: JythonCreatorContext, variables: Map[String, Any]) = {
    JythonContext.withLibrariesAndFactory(
      (Syntactic.loggerLib +: Syntactic.wrapperCodeWithLib(variables.keys)) ++ JythonSugarDiscovery.getExtensionResources
    ) {
      val scriptContext = variables.toScriptContext
      scriptContext.setWriter(new ConsumerWriter(text => jythonCreatorContext.logOutputRaw(text)))
      scriptContext.setErrorWriter(new ConsumerWriter(text => jythonCreatorContext.logErrorRaw(text)))
      scriptContext
    }
  }
}
