/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.freemarker.sanitizer;

import com.xebialabs.deployit.plugin.freemarker.sanitizer.NOOPScriptSanitizer;
import com.xebialabs.deployit.plugin.freemarker.sanitizer.UnixScriptSanitizer;
import com.xebialabs.deployit.plugin.freemarker.sanitizer.WindowsScriptSanitizer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import freemarker.template.TemplateMethodModelEx;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class OSScriptSanitizer$ {
    public static final OSScriptSanitizer$ MODULE$ = new OSScriptSanitizer$();
    private static final String SANITIZE_EXPRESSION_AUTO = "sanitize";
    private static final String SANITIZE_EXPRESSION_UNIX = "sanitizeForUnix";
    private static final String SANITIZE_EXPRESSION_WINDOWS = "sanitizeForWindows";
    private static final List<String> WINDOWS_EXTENSIONS = new .colon.colon((Object)".bat.ftl", (List)new .colon.colon((Object)".cmd.ftl", (List)new .colon.colon((Object)".bat", (List)new .colon.colon((Object)".cmd", (List)Nil$.MODULE$))));
    private static final List<String> UNIX_EXTENSIONS = new .colon.colon((Object)".sh.ftl", (List)new .colon.colon((Object)".sh", (List)Nil$.MODULE$));

    public String SANITIZE_EXPRESSION_AUTO() {
        return SANITIZE_EXPRESSION_AUTO;
    }

    public String SANITIZE_EXPRESSION_UNIX() {
        return SANITIZE_EXPRESSION_UNIX;
    }

    public String SANITIZE_EXPRESSION_WINDOWS() {
        return SANITIZE_EXPRESSION_WINDOWS;
    }

    private List<String> WINDOWS_EXTENSIONS() {
        return WINDOWS_EXTENSIONS;
    }

    private List<String> UNIX_EXTENSIONS() {
        return UNIX_EXTENSIONS;
    }

    public TemplateMethodModelEx createOSSpecificSanitizer(String templatePath, HostContainer container) {
        Option<OperatingSystemFamily> option = this.getOSFamily(templatePath, container);
        if (option instanceof Some) {
            Some some = (Some)option;
            OperatingSystemFamily os = (OperatingSystemFamily)some.value();
            OperatingSystemFamily operatingSystemFamily = os;
            if (OperatingSystemFamily.WINDOWS.equals(operatingSystemFamily)) {
                return new WindowsScriptSanitizer();
            }
            return new UnixScriptSanitizer();
        }
        if (None$.MODULE$.equals(option)) {
            return new NOOPScriptSanitizer();
        }
        throw new MatchError(option);
    }

    public Option<OperatingSystemFamily> getOSFamily(String templatePath, HostContainer container) {
        if (templatePath != null && !templatePath.isEmpty()) {
            return this.getOSForTemplatePath(templatePath);
        }
        if (container != null) {
            return Option$.MODULE$.apply((Object)container.getHost().getOs());
        }
        return None$.MODULE$;
    }

    private Option<OperatingSystemFamily> getOSForTemplatePath(String templatePath) {
        Option option;
        Option option2 = this.WINDOWS_EXTENSIONS().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)templatePath.endsWith(x$1)));
        Object object = option2 instanceof Some ? OperatingSystemFamily.WINDOWS : ((option = this.UNIX_EXTENSIONS().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)templatePath.endsWith(x$2)))) instanceof Some ? OperatingSystemFamily.UNIX : null);
        return Option$.MODULE$.apply(object);
    }

    public TemplateMethodModelEx createOSSpecificSanitizer(String templatePath) {
        return this.createOSSpecificSanitizer(templatePath, null);
    }

    public TemplateMethodModelEx createUnixSpecificSanitizer() {
        return new UnixScriptSanitizer();
    }

    public TemplateMethodModelEx createWindowsSpecificSanitizer() {
        return new WindowsScriptSanitizer();
    }

    public TemplateMethodModelEx createNOOPSpecificSanitizer() {
        return new NOOPScriptSanitizer();
    }

    private OSScriptSanitizer$() {
    }
}

