package com.xebialabs.deployit.plugin.cmd.whitelist.validator;

import org.springframework.security.core.Authentication;

import com.xebialabs.deployit.engine.tasker.query.QueryExecutorHandler;

public class CommandWhitelistPayload implements QueryExecutorHandler.QueryPayload {

    private String user;
    private String cmd;
    private Authentication authentication;

    public CommandWhitelistPayload() {
    }

    public CommandWhitelistPayload(final String user, final String cmd, Authentication authentication) {
        this.user = user;
        this.cmd = cmd;
        this.authentication = authentication;
    }

    public String getUser() {
        return user;
    }

    public void setUser(final String user) {
        this.user = user;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(final String cmd) {
        this.cmd = cmd;
    }

    public Authentication getAuthentication() {
        return authentication;
    }

    public void setAuthentication(final Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public String key() {
        return user + "_" + cmd;
    }

    @Override
    public String toString() {
        return "CommandWhitelistPayload{" +
                "user='" + user + '\'' +
                ", cmd='" + cmd + '\'' +
                ", authentication=" + authentication +
                '}';
    }
}
