package com.xebialabs.deployit.plugin.cmd.step;

import com.xebialabs.deployit.local.message.ProductName;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cmd.deployed.DeployedCommand;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

@SuppressWarnings("serial")
public class NoCommandStep implements SatelliteAware {

    private final DeployedCommand command;
    private final int order;

    public NoCommandStep(int order, DeployedCommand deployedCommand) {
        this.order = order;
        this.command = deployedCommand;
    }

    @Override
    public String getDescription() {
        return "Undo " + command.getName();
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logMsgOutput(ProductName.DEPLOY, "command.nocommand.step");
        return StepExitCode.SUCCESS;
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public Satellite getSatellite() {
        return command.getContainer().getHost().getSatellite();
    }
}
