package com.xebialabs.deployit.plugin.file;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import com.xebialabs.deployit.plugin.file.step.RescanArtifactStep;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public final class RescanArtifactDelegate {
    private RescanArtifactDelegate() {}

    @Delegate(name = "rescanArtifact")
    public static List<Step> executedScriptDelegate(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        checkArgument(item instanceof BaseDeployableArtifact, "the rescanArtifact delegate is for 'udm.BaseDeployableArtifact' subtypes only");
        return Collections.singletonList(new RescanArtifactStep((BaseDeployableArtifact) item));
    }
}
