package com.xebialabs.deployit.plugin.file;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import java.util.Set;
import java.util.TreeSet;

@SuppressWarnings("serial")
@Metadata(description = "A folder artifact that can be packaged in a Deployment Package")
public class Folder extends BaseDeployableFolderArtifact {

    @Property(required = false, description = "Path to which artifact must be copied to when being deployed.")
    private String targetPath;

    @Property(required = false, description = "Is the targetPath shared by others on the host. When true, the targetPath is not deleted during undeployment; only the artifacts copied to it.")
    private String targetPathShared;

    @Property(required = false, description = "Create the targetPath on the host if it does not exist.")
    private String createTargetPath;

    @Property(required = false, category ="Tar copy strategy", description = "Number of leading folder levels (path components) to remove from each file path before extraction.")
    private String stripComponents;

    @Property(required = false, category="Tar copy strategy", description = "Only these files or directories will be extracted from the archive.")
    private Set<String> members = new TreeSet<>();

    public Set<String> getMembers() {
        return members;
    }

    public String getStripComponents() {
        return stripComponents;
    }
}
