/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.generic.step.BaseFolderDeploymentStepSupport;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCopyStep
extends BaseFolderDeploymentStepSupport
implements StageableStep {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactCopyStep.class);
    public static final String COPYSTRATEGY_PROPERTY = "copyStrategy";
    private static final String FILE_FOLDER_TYPE_PROPERTY = "file.Folder";
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private Artifact sourceArtifact;
    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private boolean preserveExistingFiles;
    private StagedFile stagedSourceArtifact;

    public ArtifactCopyStep(int order, OverthereFile sourceFile, HostContainer container, String targetPath) {
        super(order, container);
        this.sourceFile = sourceFile;
        this.targetPath = targetPath;
        Objects.requireNonNull(targetPath);
    }

    public void requestStaging(StagingContext ctx) {
        if (this.sourceArtifact != null) {
            logger.debug("[{}] is requesting staging of [{}]", (Object)this, (Object)this.sourceArtifact);
            this.stagedSourceArtifact = ctx.stageArtifact(this.sourceArtifact, (StagingTarget)this.container.getHost());
        } else {
            logger.debug("[{}] is not requesting artifact staging.", (Object)this);
        }
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        Map metadata = this.getCtx().getTask().getMetadata();
        try {
            if (this.stagedSourceArtifact != null) {
                this.setRemoteCopyOptions();
                return this.doCopy(this.stagedSourceArtifact.get(this.getRemoteConnection(), this.getCtx()));
            }
            return this.doCopy(this.resolveSourceFile());
        }
        catch (Exception e) {
            if (Boolean.parseBoolean((String)metadata.get("enableCopyArtifactRetry"))) {
                this.getCtx().logErrorRaw(e.getMessage() + "\n");
                return StepExitCode.RETRY;
            }
            throw e;
        }
    }

    @Override
    BaseDeployableFolderArtifact getBaseDeployableFolderArtifact() {
        BaseDeployableFolderArtifact deployableFolderArtifact = null;
        if (this.getSourceArtifact() != null) {
            CopiedArtifact ca;
            Artifact artifact = this.getSourceArtifact();
            if (artifact instanceof CopiedArtifact && (ca = (CopiedArtifact)artifact).getDeployable() != null && (artifact = ca.getDeployable()) instanceof BaseDeployableFolderArtifact) {
                BaseDeployableFolderArtifact deployable;
                deployableFolderArtifact = deployable = (BaseDeployableFolderArtifact)artifact;
            } else {
                logger.debug("Source artifact {} is not a CopiedArtifact or does not have a deployable of type BaseDeployableFolderArtifact", (Object)this.getSourceArtifact().getId());
            }
        } else {
            logger.debug("Source artifact is null, cannot resolve BaseDeployableFolderArtifact");
        }
        return deployableFolderArtifact;
    }

    private void setRemoteCopyOptions() {
        ConnectionOptions connOptions = this.getRemoteConnection().getOptions();
        Host host = this.container.getHost();
        if (connOptions.getOptional("ARTIFACTFILE_COPYSTRATEGY") != null || !host.hasProperty(COPYSTRATEGY_PROPERTY)) {
            return;
        }
        CopyStrategyName strategy = (CopyStrategyName)host.getProperty(COPYSTRATEGY_PROPERTY);
        logger.debug("Setting artifact file copy strategy to {} for host {}", (Object)strategy, (Object)host.getId());
        connOptions.set("ARTIFACTFILE_COPYSTRATEGY", (Object)strategy);
    }

    private StepExitCode doCopy(OverthereFile sourceFile) {
        Objects.requireNonNull(this.targetFileName);
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetPath);
        if (!remoteDir.exists()) {
            if (this.createTargetPath) {
                this.getCtx().logOutput("Creating path " + this.targetPath + " on host " + String.valueOf(this.getContainer().getHost()));
                remoteDir.mkdirs();
            } else if (sourceFile.isFile()) {
                this.getCtx().logError("Path " + this.targetPath + " on host " + String.valueOf(this.getContainer().getHost()) + " does not exist.");
                return StepExitCode.FAIL;
            }
        }
        this.copyArtifact(sourceFile, remoteDir);
        return StepExitCode.SUCCESS;
    }

    private void copyArtifact(OverthereFile sourceFile, OverthereFile remoteDir) {
        BaseDeployableFolderArtifact baseDeployableFolderArtifact = this.getBaseDeployableFolderArtifact();
        if (baseDeployableFolderArtifact != null) {
            Artifact sa = this.getSourceArtifact();
            if (this.isForceArchivedForFolder() && sa != null && FILE_FOLDER_TYPE_PROPERTY.equals(baseDeployableFolderArtifact.getType().toString())) {
                if (this.isOneByOneCopyStrategy()) {
                    logger.debug("Artifact:Copy:Source artifact {} is a Folder artifact, proceeding with copy one by one", (Object)sa.getId());
                    this.getCtx().logOutput("Target directory:" + remoteDir.getPath() + " proceeding with copy from tmp likely one by one strategy will be very slow");
                    sourceFile.copyTo(this.getRemoteFile(sourceFile, remoteDir));
                } else {
                    logger.debug("Artifact:Copy:Source artifact {} is a Folder artifact, force archive copied", (Object)sa.getId());
                    this.getCtx().logOutput("Target directory:" + remoteDir.getPath() + " already artifact copied, so copy step skipped.");
                }
            } else {
                logger.debug("Artifact:Copy:Source artifact {} is not a Folder artifact, proceeding with copy", (Object)(sa != null ? sa.getId() : "null"));
                this.getCtx().logOutput("Target directory:" + remoteDir.getPath() + " proceeding with copy from tmp");
                sourceFile.copyTo(this.getRemoteFile(sourceFile, remoteDir));
            }
        } else {
            logger.debug("Artifact:Copy:Source file {} is not a Folder artifact, proceeding with copy", (Object)sourceFile.getPath());
            this.getCtx().logOutput("Target directory:" + remoteDir.getPath() + " proceeding with copy from tmp");
            sourceFile.copyTo(this.getRemoteFile(sourceFile, remoteDir));
        }
    }

    private OverthereFile getRemoteFile(OverthereFile sourceFile, OverthereFile remoteDir) {
        OverthereFile remoteFile;
        if (sourceFile.isDirectory()) {
            remoteFile = remoteDir;
        } else {
            remoteFile = remoteDir.getFile(this.getTargetFileName());
            if (remoteFile.exists()) {
                this.getCtx().logOutput(remoteFile.getPath() + " already exists on host " + String.valueOf(this.getContainer().getHost()) + ". Will replace.");
                remoteFile.delete();
            }
        }
        return remoteFile;
    }

    protected OverthereFile resolveSourceFile() {
        Objects.requireNonNull(this.sourceFile);
        return this.sourceFile;
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            return "Copy " + this.getSourceFileDescription() + " to " + String.valueOf(this.getContainer().getHost());
        }
        return description;
    }

    public String getSourceFileDescription() {
        return this.sourceFileDescription;
    }

    public void setSourceFileDescription(String sourceFileDescription) {
        this.sourceFileDescription = sourceFileDescription;
    }

    public Artifact getSourceArtifact() {
        return this.sourceArtifact;
    }

    public void setSourceArtifact(Artifact sourceArtifact) {
        this.sourceArtifact = sourceArtifact;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isPreserveExistingFiles() {
        return this.preserveExistingFiles;
    }

    @Deprecated
    public void setPreserveExistingFiles(boolean preserveExistingFiles) {
        Deprecations.deprecated((String)"**Deprecated** Setting property 'preserveExistingFiles' on ArtifactCopyStep is deprecated and will be ignored.", (Object[])new Object[0]);
        this.preserveExistingFiles = preserveExistingFiles;
    }
}

