/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.io.copy.CopyUtil;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.generic.step.BaseFolderDeploymentStepSupport;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactDeleteStep
extends BaseFolderDeploymentStepSupport {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactDeleteStep.class);
    private String targetDirectory;
    private DeployableArtifact artifact;
    private String targetFile;
    private boolean targetDirectoryShared;
    private boolean targetPathSharedSubDirectories;
    private Set<String> deleteAdditionalTargetFiles = Sets.newHashSet();

    public ArtifactDeleteStep() {
    }

    public ArtifactDeleteStep(int order, HostContainer container, DeployableArtifact artifact, String targetDirectory) {
        super(order, container);
        this.artifact = artifact;
        this.targetDirectory = Objects.requireNonNull(targetDirectory);
    }

    public ArtifactDeleteStep(int order, HostContainer container, String targetDirectory) {
        this(order, container, null, targetDirectory);
    }

    @Override
    protected StepExitCode doExecute() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("[ArtifactDeleteStep] Starting doExecute. artifact: {}, targetDirectory: {}, targetFile: {}", new Object[]{this.artifact != null ? this.artifact.getName() : null, this.targetDirectory, this.targetFile});
        }
        if (this.artifact != null) {
            this.deleteArtifact();
        } else {
            this.deleteTargetFile();
        }
        this.deleteAdditionalFiles(this.getDeleteAdditionalTargetFiles());
        return StepExitCode.SUCCESS;
    }

    protected void deleteArtifact() {
        if (logger.isDebugEnabled()) {
            logger.debug("[ArtifactDeleteStep] deleteArtifact called. artifact: {}, targetDirectory: {}", (Object)(this.artifact != null ? this.artifact.getName() : null), (Object)this.targetDirectory);
        }
        OverthereFile localFile = this.artifact.getFile();
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetDirectory);
        if (localFile.isDirectory()) {
            if (this.targetDirectoryShared) {
                this.deleteFilesAndFoldersForTargetShared(remoteDir, localFile);
            } else {
                logger.debug("[ArtifactDeleteStep] targetDirectoryShared is false, deleting remoteDir. remoteDir: {}", (Object)remoteDir.getPath());
                this.deleteFile(remoteDir);
            }
        } else {
            String name = Strings.nullToEmpty((String)this.targetFile).trim().isEmpty() ? this.artifact.getName() : this.targetFile;
            logger.debug("[ArtifactDeleteStep] Artifact is not a directory, deleting file: {}", (Object)name);
            this.deleteFile(remoteDir.getFile(name));
        }
    }

    protected void deleteFilesAndFoldersForTargetShared(OverthereFile remoteDir, OverthereFile localFile) {
        BaseDeployableFolderArtifact baseDeployableFolderArtifact = this.getBaseDeployableFolderArtifact();
        if (this.isTypeIsFileFolder(baseDeployableFolderArtifact) && !this.isOneByOneCopyStrategy()) {
            logger.debug("[ArtifactDeleteStep] Artifact is a directory shared. isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {}", (Object)this.isDeployableFolderArtifact(), (Object)this.isOneByOneCopyStrategy());
            int stripComponents = this.artifact.hasProperty("stripComponents") ? Integer.parseInt(this.artifact.getProperty("stripComponents").toString()) : 0;
            Set members = this.artifact.hasProperty("members") ? (Set)this.artifact.getProperty("members") : null;
            logger.debug("[ArtifactDeleteStep] targetDirectoryShared is true. stripComponents: {}, members: {}", (Object)stripComponents, (Object)members);
            if (stripComponents > 0 || members != null && !members.isEmpty()) {
                logger.debug("[ArtifactDeleteStep] deleteFilesAndFolderOnTar called for isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {} isFileFolder {} with stripComponents {} / members size {}", new Object[]{this.isDeployableFolderArtifact(), this.isOneByOneCopyStrategy(), this.isTypeIsFileFolder(baseDeployableFolderArtifact), stripComponents, members});
                if (this.isFolderCanBeDeletedRecursive() && !this.targetPathSharedSubDirectories) {
                    this.deleteOnlyRootFilesAndFoldersRecursiveOnTar(stripComponents, members, remoteDir, localFile);
                } else {
                    logger.debug("[ArtifactDeleteStep] deleteFilesAndFolderOnTar recursive delete slower for isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {} isFileFolder {} targetPathSharedSubDirectories {}", new Object[]{this.isDeployableFolderArtifact(), this.isOneByOneCopyStrategy(), this.isTypeIsFileFolder(baseDeployableFolderArtifact), this.targetPathSharedSubDirectories});
                    this.deleteFilesAndFolderOnTar(stripComponents, members, remoteDir, localFile);
                }
            } else {
                logger.debug("[ArtifactDeleteStep] deleteRemoteDir called for isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {} isFileFolder {} WITH OUT with stripComponents {} / members size {}", new Object[]{this.isDeployableFolderArtifact(), this.isOneByOneCopyStrategy(), this.isTypeIsFileFolder(baseDeployableFolderArtifact), stripComponents, members != null ? members.size() : 0});
                this.deleteRemoteDirectory(localFile, remoteDir);
            }
        } else {
            logger.debug("[ArtifactDeleteStep] deleteRemoteDir for isDeployableFolderArtifact: {}, isOneByOneCopyStrategy: {} isFileFolder {}", new Object[]{this.isDeployableFolderArtifact(), this.isOneByOneCopyStrategy(), this.isTypeIsFileFolder(baseDeployableFolderArtifact)});
            this.deleteRemoteDirectory(localFile, remoteDir);
        }
    }

    protected void deleteFilesAndFolderOnTar(int stripComponents, Set<String> members, OverthereFile remoteDir, OverthereFile localFile) {
        int stripComponentsDerived = stripComponents;
        Set<String> membersDerived = members;
        if (!this.isForceArchivedForFolder()) {
            stripComponentsDerived = stripComponents + 1;
            membersDerived = this.getMembersPathWithRootFolder(members, localFile.getName());
        }
        if (stripComponentsDerived > 0 || membersDerived != null && !membersDerived.isEmpty()) {
            Set<String> archivePaths = this.extractPathsUsingTarCommand(stripComponentsDerived, membersDerived);
            this.deleteFilesAndFolders(archivePaths, remoteDir);
        } else {
            this.deleteRemoteDirectory(localFile, remoteDir);
        }
    }

    protected void deleteOnlyRootFilesAndFoldersRecursiveOnTar(int stripComponents, Set<String> members, OverthereFile remoteDir, OverthereFile localFile) {
        int stripComponentsDerived = stripComponents;
        Set<String> membersDerived = members;
        if (!this.isForceArchivedForFolder()) {
            stripComponentsDerived = stripComponents + 1;
            membersDerived = this.getMembersPathWithRootFolder(members, localFile.getName());
        }
        if (stripComponentsDerived > 0 || membersDerived != null && !membersDerived.isEmpty()) {
            Set<String> archivePaths = this.extractPathsUsingTarCommand(stripComponentsDerived, membersDerived);
            this.deleteOnlyRootFilesAndFoldersRecursive(archivePaths, remoteDir);
        } else {
            this.deleteRemoteDirectory(localFile, remoteDir);
        }
    }

    protected boolean isTypeIsFileFolder(BaseDeployableFolderArtifact baseDeployableFolderArtifact) {
        return CopyUtil.isDeployableFileFolder((BaseDeployableFolderArtifact)baseDeployableFolderArtifact);
    }

    protected Set<String> getMembersPathWithRootFolder(Set<String> members, String srcFileName) {
        if (members == null || members.isEmpty()) {
            return members;
        }
        return members.stream().filter(member -> !member.trim().isEmpty()).map(member -> String.join((CharSequence)"/", srcFileName, member)).collect(Collectors.toSet());
    }

    protected void deleteOnlyRootFilesAndFoldersRecursive(Set<String> archivePaths, OverthereFile remoteDir) {
        logger.debug("[ArtifactDeleteStep] deleteOnlyRootFilesAndFoldersRecursive called. archivePaths: {}, remoteDir: {}", archivePaths, (Object)remoteDir.getPath());
        Set archivePathsWithoutRoot = archivePaths.stream().filter(path -> path != null && !path.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<String> processedPaths = new LinkedHashSet<String>();
        Set<String> archivePathsOnlyRoots = this.getRootFoldersAndFiles(archivePathsWithoutRoot);
        if (!archivePathsOnlyRoots.isEmpty()) {
            archivePathsOnlyRoots.forEach(path -> {
                boolean isFolderCanBeDeleted;
                OverthereFile remoteDirToDel = remoteDir.getFile(path);
                boolean bl = isFolderCanBeDeleted = remoteDirToDel.exists() && remoteDirToDel.isDirectory();
                if (isFolderCanBeDeleted) {
                    this.deleteFile(remoteDirToDel);
                    processedPaths.add(remoteDirToDel.getPath());
                    this.getCtx().logOutput("Deleted directory: " + remoteDirToDel.getPath());
                }
            });
            Set filesAndDirectoriesPathNotProcessedOnlyRoot = archivePathsWithoutRoot.stream().filter(path -> !processedPaths.contains(path)).filter(path -> path != null && !path.trim().isEmpty() && !path.contains("/")).collect(Collectors.toCollection(LinkedHashSet::new));
            filesAndDirectoriesPathNotProcessedOnlyRoot.forEach(path -> {
                boolean isFileCanBeDeleted;
                OverthereFile remoteDirFileToDelete = remoteDir.getFile(path);
                boolean bl = isFileCanBeDeleted = remoteDirFileToDelete != null && remoteDirFileToDelete.exists() && remoteDirFileToDelete.isFile();
                if (isFileCanBeDeleted) {
                    this.deleteFile(remoteDirFileToDelete);
                    processedPaths.add(remoteDirFileToDelete.getPath());
                }
            });
            this.processedPathShouldNotBeEmpty(remoteDir, processedPaths);
        } else {
            logger.debug("[ArtifactDeleteStep] No root files or folders found in archivePathsWithoutRoot: {}", (Object)archivePathsWithoutRoot);
            this.deleteFilesAndFolders(archivePathsWithoutRoot, remoteDir);
        }
    }

    protected final Set<String> getRootFoldersAndFiles(Set<String> archivePathsWithoutRoot) {
        return archivePathsWithoutRoot.stream().map(path -> path.contains("/") ? path.substring(0, path.indexOf("/")) : path).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected void deleteFilesAndFolders(Set<String> archivePaths, OverthereFile remoteDir) {
        logger.debug("[ArtifactDeleteStep]  deleteFilesAndFolders called. archivePaths: {}, remoteDir: {}", archivePaths, (Object)remoteDir.getPath());
        Set archivePathsWithoutRoot = archivePaths.stream().filter(path -> path != null && !path.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<String> processedPaths = new LinkedHashSet<String>();
        archivePathsWithoutRoot.forEach(path -> {
            boolean isFileCanBeDeleted;
            OverthereFile remoteDirFileToDelete = remoteDir.getFile(path);
            boolean bl = isFileCanBeDeleted = remoteDirFileToDelete != null && remoteDirFileToDelete.exists() && remoteDirFileToDelete.isFile();
            if (isFileCanBeDeleted) {
                this.deleteFile(remoteDirFileToDelete);
                processedPaths.add(remoteDirFileToDelete.getPath());
            }
        });
        Set processedRelativePaths = processedPaths.stream().map(absPath -> {
            String base = remoteDir.getPath();
            if (absPath.startsWith(base)) {
                String rel = absPath.substring(base.length());
                if (rel.startsWith("/")) {
                    rel = rel.substring(1);
                }
                return rel;
            }
            return absPath;
        }).collect(Collectors.toSet());
        Set filesAndDirectoriesPathNotProcessed = archivePathsWithoutRoot.stream().filter(path -> !processedRelativePaths.contains(path)).filter(path -> path != null && !path.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        Set<String> rootDirectoriesPathNotProcessed = this.getRootFoldersAndFiles(filesAndDirectoriesPathNotProcessed);
        Set<String> allowedDirsAbs = null;
        if (this.targetPathSharedSubDirectories && !rootDirectoriesPathNotProcessed.isEmpty()) {
            allowedDirsAbs = this.getAllowedDirsToDelete(remoteDir, archivePaths);
            logger.debug("[ArtifactDeleteStep] deleteFolderIfEmpty called for allPaths {}, allowedDirsAbs: {}", archivePaths, allowedDirsAbs);
        }
        for (String path2 : rootDirectoriesPathNotProcessed) {
            OverthereFile remoteDirToDel = remoteDir.getFile(path2);
            boolean isFolderCanBeDeleted = remoteDirToDel.exists() && remoteDirToDel.isDirectory();
            if (!isFolderCanBeDeleted) continue;
            if (this.targetPathSharedSubDirectories) {
                this.deleteFolderIfEmpty(remoteDirToDel, processedPaths, allowedDirsAbs);
                continue;
            }
            this.deleteFile(remoteDirToDel);
            processedPaths.add(remoteDirToDel.getPath());
            this.getCtx().logOutput("Deleted directory: " + remoteDirToDel.getPath());
        }
        this.processedPathShouldNotBeEmpty(remoteDir, processedPaths);
    }

    protected Set<String> getAllowedDirsToDelete(OverthereFile remoteDir, Set<String> archivePaths) {
        LinkedHashSet<String> allowedDirsAbs = new LinkedHashSet<String>();
        for (String path : archivePaths) {
            if (path != null && !path.trim().isEmpty()) {
                OverthereFile remoteDirToDelete = remoteDir.getFile(path);
                boolean isFolderExist = remoteDirToDelete != null && remoteDirToDelete.exists() && remoteDirToDelete.isDirectory();
                if (!isFolderExist) continue;
                allowedDirsAbs.add(remoteDirToDelete.getPath());
                continue;
            }
            logger.debug("[ArtifactDeleteStep] Skipping empty path in archivePaths: {}", (Object)path);
        }
        return allowedDirsAbs;
    }

    private void processedPathShouldNotBeEmpty(OverthereFile remoteDir, Set<String> processedPaths) {
        if (processedPaths.isEmpty()) {
            this.getCtx().logError("No files or directories were deleted from " + remoteDir.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
            throw new RuntimeIOException("No files or directories were deleted from " + remoteDir.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        }
        this.getCtx().logOutput("Deleted files and directories: " + String.join((CharSequence)", ", processedPaths) + " on host " + String.valueOf(this.getContainer().getHost()));
    }

    private void deleteRemoteDirectory(OverthereFile localFile, OverthereFile remoteDir) {
        for (OverthereFile file : localFile.listFiles()) {
            OverthereFile remoteFile = remoteDir.getFile(file.getName());
            if (this.targetPathSharedSubDirectories && file.isDirectory()) {
                if (remoteFile.exists()) {
                    this.deleteRemoteDirectory(file, remoteFile);
                    if (!remoteFile.listFiles().isEmpty()) continue;
                    this.deleteFile(remoteFile);
                    continue;
                }
                this.getCtx().logOutput(remoteFile.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
                continue;
            }
            this.deleteFile(remoteFile);
        }
    }

    protected void deleteTargetFile() {
        OverthereFile remoteFile = this.getRemoteConnection().getFile(this.targetDirectory);
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            remoteFile = remoteFile.getFile(this.targetFile);
        }
        this.deleteFile(remoteFile);
    }

    protected void deleteAdditionalFiles(Set<String> files) {
        for (String file : files) {
            OverthereFile remoteFile = this.getRemoteConnection().getFile(file);
            if (remoteFile.exists()) {
                this.getCtx().logOutput("Deleting " + remoteFile.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
                remoteFile.deleteRecursively();
                continue;
            }
            this.getCtx().logOutput(remoteFile.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
        }
    }

    protected void deleteFile(OverthereFile file) {
        this.getCtx().logOutput("Deleting " + file.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        if (file.exists()) {
            file.deleteRecursively();
        } else {
            this.getCtx().logOutput(file.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
        }
    }

    protected void deleteFolderIfEmpty(OverthereFile folder, Set<String> processedPaths, Set<String> allowedDirsAbs) {
        this.getCtx().logOutput("Deleting " + folder.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        if (!folder.exists()) {
            this.getCtx().logOutput(folder.getPath() + " does not exist on host " + String.valueOf(this.getContainer().getHost()) + ". Will not perform delete.");
            return;
        }
        List children = folder.listFiles();
        for (OverthereFile child : children) {
            if (!child.exists() || !child.isDirectory()) continue;
            this.deleteFolderIfEmpty(child, processedPaths, allowedDirsAbs);
        }
        List remaining = folder.listFiles();
        if (remaining.isEmpty()) {
            if (allowedDirsAbs != null && allowedDirsAbs.contains(folder.getPath())) {
                folder.deleteRecursively();
                this.getCtx().logOutput("Deleted directory: " + folder.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
                processedPaths.add(folder.getPath());
            } else {
                logger.debug("Skip deleting {} as it is not present in archive paths", (Object)folder.getPath());
            }
        } else {
            logger.debug("Skip deleting {} because it is not empty after deletion of subfolders", (Object)folder.getPath());
        }
    }

    protected Set<String> extractPathsUsingTarCommand(Integer stripComponents, Set<String> members) {
        LocalFile sourceArtifactLocalFolder = (LocalFile)LocalFile.valueOf((File)((SourceArtifactFile)this.artifact.getFile()).getLocalFile());
        LocalFile sourceArtifactLocalFolderAsTar = this.folderAsTar(sourceArtifactLocalFolder);
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument("tar");
        cmdLine.addArgument("-tf");
        cmdLine.addArgument(sourceArtifactLocalFolderAsTar.getPath());
        if (stripComponents != null && stripComponents > 0) {
            cmdLine.addArgument("--strip-components=" + stripComponents);
        }
        if (members != null && !members.isEmpty()) {
            for (String member : members) {
                if (member.trim().isEmpty()) continue;
                cmdLine.addArgument(member);
            }
        }
        Set<String> paths = this.executeTarCommandAndExtractPath(stripComponents, cmdLine, sourceArtifactLocalFolderAsTar);
        logger.debug("[ArtifactDeleteStep] extractPathsUsingTarCommand called. stripComponents: {}, members: {}, paths: {}", new Object[]{stripComponents, members, paths});
        return paths;
    }

    protected Set<String> executeTarCommandAndExtractPath(Integer stripComponents, CmdLine cmdLine, LocalFile sourceArtifactLocalFolderAsTar) {
        Set<String> paths = new LinkedHashSet<String>();
        try {
            StringBuilder stdout = new StringBuilder();
            StringBuilder stderr = new StringBuilder();
            OverthereExecutionOutputHandler stdoutHandler = this.createOutputHandler(stdout);
            OverthereExecutionOutputHandler stderrHandler = this.createOutputHandler(stderr);
            int exitCode = this.artifact.getFile().getConnection().execute(stdoutHandler, stderrHandler, cmdLine);
            if (exitCode != 0) {
                throw new RuntimeException("Error executing tar command. Exit code: " + exitCode + ". Error: " + String.valueOf(stderr));
            }
            paths = this.getStrippedPaths(stripComponents, stdout);
        }
        catch (Exception e) {
            this.getCtx().logError("Error executing while fetch using tar command: " + e.getMessage());
        }
        if (paths.isEmpty()) {
            this.getCtx().logOutput("No files found in the tar archive to delete:" + sourceArtifactLocalFolderAsTar.getPath() + " on host " + String.valueOf(this.getContainer().getHost()));
        }
        return paths;
    }

    protected Set<String> getStrippedPaths(Integer stripComponents, StringBuilder stdout) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        Arrays.stream(stdout.toString().split("\n")).forEach(path -> this.addPathByStripComponents(stripComponents, (String)path, (Set<String>)paths));
        return paths;
    }

    private void addPathByStripComponents(Integer stripComponents, String path, Set<String> paths) {
        String[] components = path.split("/");
        if (stripComponents != null && stripComponents >= 0) {
            this.addStrippedPath(stripComponents, components, paths);
        } else {
            paths.add(path);
        }
    }

    private void addStrippedPath(Integer stripComponents, String[] components, Set<String> paths) {
        if (stripComponents < components.length) {
            paths.add(String.join((CharSequence)"/", Arrays.copyOfRange(components, (int)stripComponents, components.length)));
        }
    }

    private OverthereExecutionOutputHandler createOutputHandler(final StringBuilder output) {
        return new OverthereExecutionOutputHandler(){

            public void handleLine(String line) {
                output.append(line).append("\n");
            }

            public void handleChar(char c) {
            }
        };
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            return this.generateDescription();
        }
        return description;
    }

    @Override
    BaseDeployableFolderArtifact getBaseDeployableFolderArtifact() {
        return this.artifact instanceof BaseDeployableFolderArtifact ? (BaseDeployableFolderArtifact)this.artifact : null;
    }

    protected String generateDescription() {
        if (this.artifact != null) {
            return "Delete " + this.artifact.getName() + " from " + String.valueOf(this.getContainer().getHost());
        }
        if (!Strings.nullToEmpty((String)this.targetFile).trim().isEmpty()) {
            return "Delete file " + this.targetFile + " from directory " + this.targetDirectory + " on host " + String.valueOf(this.getContainer().getHost());
        }
        return "Delete directory " + this.targetDirectory + " from  " + String.valueOf(this.getContainer().getHost());
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isTargetDirectoryShared() {
        return this.targetDirectoryShared;
    }

    public void setTargetDirectoryShared(boolean targetDirectoryShared) {
        this.targetDirectoryShared = targetDirectoryShared;
    }

    public Set<String> getDeleteAdditionalTargetFiles() {
        return this.deleteAdditionalTargetFiles;
    }

    public void setDeleteAdditionalTargetFiles(Set<String> deleteAdditionalTargetFiles) {
        this.deleteAdditionalTargetFiles = deleteAdditionalTargetFiles;
    }

    public void setTargetPathSharedSubDirectories(boolean targetPathSharedSubDirectories) {
        this.targetPathSharedSubDirectories = targetPathSharedSubDirectories;
    }
}

