/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import ai.digital.deploy.gitops.util.AsCodeResponseLogger;
import ai.digital.deploy.gitops.util.SCMInfo;
import ai.digital.deploy.gitops.util.SCMInfoExtractor;
import ai.digital.deploy.gitops.util.YamlKindFilter;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitApplyEnvironmentStep
implements Step {
    private static final String ENVIRONMENT_YAML = "environment.yaml";
    private final String gitDirectoryId;

    public GitApplyEnvironmentStep(String gitDirectoryId) {
        this.gitDirectoryId = gitDirectoryId;
    }

    public String getDescription() {
        return "Import Environment";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting Environment import validation and apply");
        Object directoryAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (directoryAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Path directoryPath = Paths.get(directoryAttr.toString(), new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0]) || !Files.isDirectory(directoryPath, new LinkOption[0])) {
            ctx.logError("Directory missing or invalid: " + String.valueOf(directoryPath));
            return StepExitCode.FAIL;
        }
        Path environmentYamlPath = directoryPath.resolve(ENVIRONMENT_YAML);
        ctx.logOutput("Looking for environment.yaml in: " + String.valueOf(directoryPath));
        if (!Files.exists(environmentYamlPath, new LinkOption[0])) {
            ctx.logError("environment.yaml not found in directory: " + String.valueOf(directoryPath));
            ctx.logError("Please ensure the file exists or skip this step manually.");
            return StepExitCode.FAIL;
        }
        ctx.logOutput("Found environment.yaml: " + String.valueOf(environmentYamlPath));
        return this.applyYamlFile(environmentYamlPath, ctx);
    }

    private StepExitCode applyYamlFile(Path yamlFile, ExecutionContext ctx) {
        XLDAsCodeService xldAsCodeService = ServiceHolder.getXLDAsCodeService();
        GitOpsServiceHolder.GitOpsServiceAdapter adapter = null;
        if (xldAsCodeService == null) {
            ctx.logOutput("XLDAsCodeService not available. Falling back to adapter.");
            adapter = GitOpsServiceHolder.getGitOpsService();
        }
        try {
            XLDAsCodeResult result;
            String yamlContent = new String(Files.readAllBytes(yamlFile));
            if (yamlContent.trim().isEmpty()) {
                ctx.logOutput("environment.yaml is empty. Skipping.");
                return StepExitCode.SUCCESS;
            }
            this.checkMultipleSpecDirectories(yamlContent, ctx);
            ctx.logOutput("Validating YAML content for Environments kind...");
            YamlKindFilter.FilterResult filterResult = YamlKindFilter.filterByKind(yamlContent, "Environments", ctx);
            YamlKindFilter.logSkippedDocuments(filterResult, ENVIRONMENT_YAML, "Environments", ctx);
            ctx.logOutput("  Found " + filterResult.getMatchingDocuments() + " of " + filterResult.getTotalDocuments() + " document(s) with kind: Environments");
            if (!filterResult.hasContent()) {
                ctx.logError("No Environments documents found in environment.yaml.");
                ctx.logError("The file must contain at least one document with 'kind: Environments'.");
                return StepExitCode.FAIL;
            }
            ctx.logOutput("Applying environment.yaml (Environments kind only)...");
            SCMInfo scmData = this.getSCMDataForFile(ctx, ENVIRONMENT_YAML);
            if (xldAsCodeService != null) {
                if (scmData != null && scmData.hasCommit()) {
                    ctx.logOutput("Applying with SCM traceability (commit: " + scmData.getCommit().substring(0, Math.min(7, scmData.getCommit().length())) + ")");
                    result = xldAsCodeService.applyWithScm(filterResult.getFilteredContent(), scmData.getKind(), scmData.getCommit(), scmData.getAuthor(), scmData.getDate(), scmData.getMessage(), scmData.getRemote(), scmData.getFileName());
                } else {
                    result = xldAsCodeService.apply(filterResult.getFilteredContent());
                }
            } else {
                result = adapter.apply(filterResult.getFilteredContent());
            }
            if (result.isSuccess()) {
                ctx.logOutput("Successfully applied environment.yaml");
                AsCodeResponseLogger.logChanges(result, ctx);
                return StepExitCode.SUCCESS;
            }
            ctx.logError("Failed to apply environment.yaml");
            ctx.logError("Reason: " + result.getMessage());
            if (result.getError() != null) {
                ctx.logError("Error: " + result.getError());
            }
            return StepExitCode.FAIL;
        }
        catch (Exception e) {
            ctx.logError("Exception processing environment.yaml: " + e.getMessage());
            return StepExitCode.FAIL;
        }
    }

    private SCMInfo getSCMDataForFile(ExecutionContext ctx, String fileName) {
        Object scmAttr = ctx.getAttribute("gitOps.scmTraceabilityData");
        if (scmAttr instanceof SCMInfo) {
            SCMInfo baseSCM = (SCMInfo)scmAttr;
            return baseSCM.withFileName(fileName);
        }
        Object remoteUrlAttr = ctx.getAttribute("gitOps.gitRemoteUrl");
        if (remoteUrlAttr != null) {
            return SCMInfoExtractor.createMinimalSCMInfo(remoteUrlAttr.toString(), fileName);
        }
        return null;
    }

    private void checkMultipleSpecDirectories(String yamlContent, ExecutionContext ctx) {
        Pattern pattern = Pattern.compile("^\\s*-\\s*directory\\s*:", 8);
        Matcher matcher = pattern.matcher(yamlContent);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count > 1) {
            ctx.logError("Warning: Found " + count + " spec.directory entries in environment.yaml. Multiple directory specifications detected. Proceeding with import.");
        }
    }

    public int getOrder() {
        return 30;
    }
}

