/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitCommitAndPushStep
implements Step {
    private static final String INFRASTRUCTURE_YAML = "infrastructure.yaml";
    private static final String ENVIRONMENT_YAML = "environment.yaml";
    private final String gitDirectoryId;
    private final String username;
    private final String password;
    private final String tagName;

    public GitCommitAndPushStep(String gitDirectoryId, String username, String password, String tagName) {
        this.gitDirectoryId = gitDirectoryId;
        this.username = username;
        this.password = password;
        this.tagName = tagName;
    }

    public String getDescription() {
        return "Commit and Push to Git";
    }

    public int getOrder() {
        return 40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting Git commit and push");
        Object localRepoDirAttr = ctx.getAttribute("gitOps.localRepoDir");
        if (localRepoDirAttr == null) {
            ctx.logError("Local repository directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Object targetDirAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (targetDirAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        File localRepoDir = new File(localRepoDirAttr.toString());
        Path targetDirectory = Paths.get(targetDirAttr.toString(), new String[0]);
        ctx.logOutput("Local repository: " + localRepoDir.getAbsolutePath());
        ctx.logOutput("Target directory: " + String.valueOf(targetDirectory));
        try (Git git = null;){
            Iterator<Object> iterator;
            git = Git.open((File)localRepoDir);
            Path repoPath = localRepoDir.toPath();
            Path relativeTarget = repoPath.relativize(targetDirectory);
            String infrastructureRelPath = relativeTarget.resolve(INFRASTRUCTURE_YAML).toString().replace('\\', '/');
            String environmentRelPath = relativeTarget.resolve(ENVIRONMENT_YAML).toString().replace('\\', '/');
            ctx.logOutput("Staging files...");
            ctx.logOutput("  - " + infrastructureRelPath);
            ctx.logOutput("  - " + environmentRelPath);
            AddCommand addCommand = git.add();
            addCommand.addFilepattern(infrastructureRelPath);
            addCommand.addFilepattern(environmentRelPath);
            addCommand.call();
            Status status = git.status().call();
            HashSet staged = new HashSet(status.getAdded());
            staged.addAll(status.getChanged());
            if (staged.isEmpty() && status.getModified().isEmpty()) {
                ctx.logOutput("No changes detected. Nothing to commit.");
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            ctx.logOutput("Changes staged for commit:");
            for (String file : staged) {
                ctx.logOutput("  Added/Changed: " + file);
            }
            for (String file : status.getModified()) {
                git.add().addFilepattern(file).call();
                ctx.logOutput("  Modified: " + file);
            }
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            ctx.logOutput("Using tag: " + this.tagName);
            String commitMessage = String.format("GitOps Export [%s]: Updated infrastructure and environment YAMLs\n\nTag: %s\nExported from XL Deploy at %s\nGit Directory: %s", this.tagName, this.tagName, timestamp, this.gitDirectoryId);
            ctx.logOutput("Committing changes...");
            CommitCommand commitCommand = git.commit();
            commitCommand.setMessage(commitMessage);
            if (this.username != null && !this.username.isEmpty()) {
                commitCommand.setAuthor(this.username, this.username + "@xldeploy.local");
                commitCommand.setCommitter(this.username, this.username + "@xldeploy.local");
            }
            RevCommit commit = commitCommand.call();
            ctx.logOutput("Commit successful: " + commit.getId().getName());
            String tagMessage = String.format("XLD Export at %s", timestamp);
            ctx.logOutput("Creating tag: " + this.tagName);
            git.tag().setName(this.tagName).setMessage(tagMessage).setAnnotated(true).call();
            ctx.logOutput("Tag created successfully: " + this.tagName);
            ctx.logOutput("Pushing to remote repository...");
            PushCommand pushCommand = git.push();
            if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
                pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password));
            }
            Iterable pushResults = pushCommand.call();
            boolean pushSuccess = true;
            for (PushResult pushResult : pushResults) {
                for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                    RemoteRefUpdate.Status updateStatus = update.getStatus();
                    ctx.logOutput("Push status for " + update.getRemoteName() + ": " + String.valueOf(updateStatus));
                    if (updateStatus == RemoteRefUpdate.Status.OK || updateStatus == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                    pushSuccess = false;
                    ctx.logError("Push failed: " + update.getMessage());
                }
            }
            ctx.logOutput("Pushing tags to remote repository...");
            PushCommand pushTagsCommand = git.push().setPushTags();
            if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
                pushTagsCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password));
            }
            Iterable tagPushResults = pushTagsCommand.call();
            for (PushResult pushResult : tagPushResults) {
                for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                    RemoteRefUpdate.Status updateStatus = update.getStatus();
                    ctx.logOutput("Tag push status for " + update.getRemoteName() + ": " + String.valueOf(updateStatus));
                    if (updateStatus == RemoteRefUpdate.Status.OK || updateStatus == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                    ctx.logOutput("Warning: Tag push may have issues: " + update.getMessage());
                }
            }
            if (pushSuccess) {
                ctx.logOutput("Successfully pushed changes and tag '" + this.tagName + "' to remote repository");
                iterator = StepExitCode.SUCCESS;
                return iterator;
            }
            ctx.logError("Push to remote repository failed");
            iterator = StepExitCode.FAIL;
            return iterator;
        }
    }
}

