/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GitGenerateEnvironmentStep
implements Step {
    private static final String ENVIRONMENT_YAML = "environment.yaml";
    private final String gitDirectoryId;
    private final String environmentTargetDir;

    public GitGenerateEnvironmentStep(String gitDirectoryId, String environmentTargetDir) {
        this.gitDirectoryId = gitDirectoryId;
        this.environmentTargetDir = environmentTargetDir;
    }

    public String getDescription() {
        return "Export Environment";
    }

    public int getOrder() {
        return 30;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting Environment export");
        ctx.logOutput("Environment target directory: " + this.environmentTargetDir);
        Object directoryAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (directoryAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Path directoryPath = Paths.get(directoryAttr.toString(), new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0]) || !Files.isDirectory(directoryPath, new LinkOption[0])) {
            ctx.logError("Directory missing or invalid: " + String.valueOf(directoryPath));
            return StepExitCode.FAIL;
        }
        Path environmentYamlPath = directoryPath.resolve(ENVIRONMENT_YAML);
        ctx.logOutput("Will generate environment.yaml at: " + String.valueOf(environmentYamlPath));
        return this.generateYamlFile(environmentYamlPath, ctx);
    }

    private StepExitCode generateYamlFile(Path yamlFile, ExecutionContext ctx) {
        XLDAsCodeService xldAsCodeService = ServiceHolder.getXLDAsCodeService();
        GitOpsServiceHolder.GitOpsServiceAdapter adapter = null;
        if (xldAsCodeService == null) {
            ctx.logOutput("XLDAsCodeService not available. Falling back to adapter.");
            adapter = GitOpsServiceHolder.getGitOpsService();
        }
        try {
            String fullPath = this.ensureEnvironmentsPath(this.environmentTargetDir);
            ctx.logOutput("Generating YAML from path: " + fullPath);
            XLDAsCodeResult result = xldAsCodeService != null ? xldAsCodeService.generate(fullPath, false, false, false, false, false) : adapter.generate(fullPath, false, false, false, false, false);
            if (result == null) {
                ctx.logError("Generate returned null result for path: " + fullPath);
                return StepExitCode.FAIL;
            }
            if (!result.isSuccess()) {
                ctx.logError("Failed to generate YAML: " + (result.getError() != null ? result.getError() : "Unknown error"));
                return StepExitCode.FAIL;
            }
            Object yamlContent = result.getContent();
            if (yamlContent == null || ((String)yamlContent).trim().isEmpty()) {
                ctx.logOutput("No CIs found in " + this.environmentTargetDir + ". Creating empty environment.yaml.");
                yamlContent = "# No environment CIs found in " + this.environmentTargetDir + "\n";
            }
            Files.write(yamlFile, ((String)yamlContent).getBytes(), new OpenOption[0]);
            ctx.logOutput("Successfully generated environment.yaml with " + ((String)yamlContent).length() + " bytes");
            if (result.getMessage() != null && !result.getMessage().isEmpty()) {
                ctx.logOutput("Generation message: " + result.getMessage());
            }
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            ctx.logError("Failed to generate environment.yaml: " + e.getMessage(), (Throwable)e);
            return StepExitCode.FAIL;
        }
    }

    private String ensureEnvironmentsPath(String path) {
        if (path == null || path.trim().isEmpty()) {
            return path;
        }
        String trimmedPath = path.trim();
        if (trimmedPath.startsWith("Environments/") || trimmedPath.equals("Environments")) {
            return trimmedPath;
        }
        return "Environments/" + trimmedPath;
    }
}

