/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import ai.digital.deploy.gitops.util.YamlHandler;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StepMetadata(name="xldAsCodeApply")
public class GitOpsApplyStep
implements SatelliteAware {
    private static final Logger logger = LoggerFactory.getLogger(GitOpsApplyStep.class);
    private ConfigurationItem gitSource;
    private String repositoryPath;

    public GitOpsApplyStep() {
    }

    public GitOpsApplyStep(ConfigurationItem gitSource, String repositoryPath) {
        this.gitSource = gitSource;
        this.repositoryPath = repositoryPath;
    }

    public String getDescription() {
        return "Apply YAML files through XLDAsCodeService";
    }

    public int getOrder() {
        return 60;
    }

    public Satellite getSatellite() {
        return null;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting apply operation");
        ctx.logOutput("Repository path: " + this.repositoryPath);
        try {
            if (!this.validateRepositoryPath(ctx)) {
                return StepExitCode.SUCCESS;
            }
            ctx.logOutput("Scanning and reading YAML files...");
            List<YamlHandler.YamlContent> yamlContents = YamlHandler.scanAndReadYamlFiles(this.repositoryPath);
            if (yamlContents.isEmpty()) {
                ctx.logOutput("No YAML files found in repository");
                return StepExitCode.SUCCESS;
            }
            List<YamlHandler.YamlContent> validContents = yamlContents.stream().filter(YamlHandler.YamlContent::isSuccess).toList();
            ctx.logOutput("Found " + validContents.size() + " valid YAML files to process");
            if (validContents.isEmpty()) {
                ctx.logOutput("No valid YAML content to process");
                return StepExitCode.SUCCESS;
            }
            List<YamlHandler.YamlContent> sortedContents = this.sortYamlFilesByProcessingOrder(validContents);
            ctx.logOutput("Processing " + sortedContents.size() + " YAML files...");
            int successCount = 0;
            int failureCount = 0;
            XLDAsCodeService xldAsCodeService = this.getXLDAsCodeService();
            GitOpsServiceHolder.GitOpsServiceAdapter adapter = null;
            if (xldAsCodeService == null) {
                ctx.logOutput("External worker mode - using adapter approach");
                adapter = GitOpsServiceHolder.getGitOpsService();
            }
            for (YamlHandler.YamlContent yamlContent : sortedContents) {
                String relativePath = YamlHandler.getRelativePathForDisplay(this.repositoryPath, yamlContent.getFilePath());
                try {
                    XLDAsCodeResult result;
                    if (yamlContent.getContent().trim().isEmpty()) {
                        ctx.logOutput("  Skipped (empty file): " + relativePath);
                        continue;
                    }
                    XLDAsCodeResult xLDAsCodeResult = result = xldAsCodeService != null ? xldAsCodeService.apply(yamlContent.getContent()) : adapter.apply(yamlContent.getContent());
                    if (result.isSuccess()) {
                        ctx.logOutput("Success: " + relativePath);
                        if (result.getMessage() != null) {
                            ctx.logOutput("    " + result.getMessage());
                        }
                        ++successCount;
                        continue;
                    }
                    ctx.logOutput("Failed: " + relativePath);
                    ctx.logOutput("Reason: " + result.getMessage());
                    if (result.getError() != null) {
                        ctx.logError("Error Details: " + result.getError());
                    }
                    ++failureCount;
                }
                catch (Exception e) {
                    ctx.logOutput("Exception: " + relativePath + " - " + e.getMessage());
                    logger.error("Exception processing YAML file: {}", (Object)yamlContent.getFilePath(), (Object)e);
                    ++failureCount;
                }
            }
            ctx.logOutput("Processing complete: " + successCount + " successful, " + failureCount + " failed");
            return successCount > 0 ? StepExitCode.SUCCESS : StepExitCode.FAIL;
        }
        catch (Exception e) {
            ctx.logError("Error during apply operation: " + e.getMessage());
            logger.error("Error in GitOpsApplyStep", (Throwable)e);
            return StepExitCode.FAIL;
        }
    }

    private boolean validateRepositoryPath(ExecutionContext ctx) {
        File repoDir;
        if (this.repositoryPath == null || this.repositoryPath.trim().isEmpty()) {
            ctx.logOutput("Repository path is not specified - will attempt to find cloned repository");
            this.repositoryPath = this.findActualRepositoryPath(ctx);
            if (this.repositoryPath == null) {
                ctx.logOutput("Could not locate cloned repository");
                return false;
            }
        }
        if (!(repoDir = new File(this.repositoryPath)).exists()) {
            ctx.logOutput("Repository path does not exist: " + this.repositoryPath);
            String actualPath = this.findActualRepositoryPath(ctx);
            if (actualPath != null) {
                ctx.logOutput("Found actual repository at: " + actualPath);
                this.repositoryPath = actualPath;
                repoDir = new File(this.repositoryPath);
            } else {
                return false;
            }
        }
        if (!repoDir.isDirectory()) {
            ctx.logOutput("Repository path is not a directory: " + this.repositoryPath);
            return false;
        }
        ctx.logOutput("Repository path validated: " + this.repositoryPath);
        return true;
    }

    private String findActualRepositoryPath(ExecutionContext ctx) {
        if (this.gitSource == null) {
            return null;
        }
        try {
            return this.searchInGitReposDirectory(ctx);
        }
        catch (Exception e) {
            ctx.logOutput("Error while determining repository path: " + e.getMessage());
            return null;
        }
    }

    private String searchInGitReposDirectory(ExecutionContext ctx) {
        try {
            String serverHome = System.getProperty("user.dir");
            File gitReposDir = new File(serverHome, "work" + File.separator + "git_repos");
            if (!gitReposDir.exists() || !gitReposDir.isDirectory()) {
                ctx.logOutput("Git repos directory not found: " + gitReposDir.getAbsolutePath());
                return null;
            }
            ctx.logOutput("Searching for Git repositories in: " + gitReposDir.getAbsolutePath());
            File[] repoDirs = gitReposDir.listFiles(File::isDirectory);
            if (repoDirs == null || repoDirs.length == 0) {
                ctx.logOutput("No directories found in git_repos");
                return null;
            }
            ctx.logOutput("Found " + repoDirs.length + " directories in git_repos");
            File mostRecent = repoDirs[0];
            for (File dir : repoDirs) {
                if (dir.lastModified() <= mostRecent.lastModified()) continue;
                mostRecent = dir;
            }
            ctx.logOutput("Most recent repository directory: " + mostRecent.getAbsolutePath());
            if (this.isValidGitRepository(mostRecent.getAbsolutePath())) {
                ctx.logOutput("Found Git repository at: " + mostRecent.getAbsolutePath());
                return mostRecent.getAbsolutePath();
            }
            File[] subdirs = mostRecent.listFiles(File::isDirectory);
            if (subdirs != null && subdirs.length > 0) {
                for (File subdir : subdirs) {
                    if (!this.isValidGitRepository(subdir.getAbsolutePath())) continue;
                    ctx.logOutput("Found Git repository at: " + subdir.getAbsolutePath());
                    return subdir.getAbsolutePath();
                }
            }
            ctx.logOutput("No valid Git repository found in: " + mostRecent.getAbsolutePath());
        }
        catch (Exception e) {
            ctx.logOutput("Error searching temp directories: " + e.getMessage());
        }
        return null;
    }

    private boolean isValidGitRepository(String path) {
        if (path == null || path.trim().isEmpty()) {
            return false;
        }
        try {
            File dir = new File(path);
            if (!dir.exists() || !dir.isDirectory()) {
                return false;
            }
            File gitDir = new File(dir, ".git");
            return gitDir.exists() && gitDir.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    private XLDAsCodeService getXLDAsCodeService() {
        try {
            XLDAsCodeService service = GitOpsServiceHolder.getService();
            if (service != null) {
                String className = service.getClass().getName();
                if (className.contains("$Proxy") || className.contains("jdk.proxy")) {
                    return null;
                }
                return service;
            }
            return null;
        }
        catch (Exception e) {
            logger.debug("ServiceHolder not available: {}", (Object)e.getMessage());
            return null;
        }
    }

    private List<YamlHandler.YamlContent> sortYamlFilesByProcessingOrder(List<YamlHandler.YamlContent> yamlContents) {
        return yamlContents.stream().sorted((a, b) -> {
            int orderB;
            int orderA = this.getProcessingOrder((YamlHandler.YamlContent)a);
            if (orderA != (orderB = this.getProcessingOrder((YamlHandler.YamlContent)b))) {
                return Integer.compare(orderA, orderB);
            }
            return a.getFilePath().compareTo(b.getFilePath());
        }).toList();
    }

    private int getProcessingOrder(YamlHandler.YamlContent yamlContent) {
        String filePath = yamlContent.getFilePath().toLowerCase().replace('\\', '/');
        String content = yamlContent.getContent().toLowerCase();
        if (content.contains("type: udm.dictionary")) {
            return 1;
        }
        if (filePath.contains("/infrastructure/") || content.contains("kind: infrastructure")) {
            return 2;
        }
        if (filePath.contains("/environments/") || content.contains("kind: environments")) {
            return 3;
        }
        if (filePath.contains("/applications/") || content.contains("kind: applications")) {
            return 4;
        }
        return 5;
    }
}

