/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.util;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YamlKindFilter {
    public static final String KIND_INFRASTRUCTURE = "Infrastructure";
    public static final String KIND_ENVIRONMENTS = "Environments";
    private static final Pattern KIND_PATTERN = Pattern.compile("^kind\\s*:\\s*(.+)$", 8);

    public static FilterResult filterByKind(String yamlContent, String expectedKind, ExecutionContext ctx) {
        if (yamlContent == null || yamlContent.trim().isEmpty()) {
            return new FilterResult("", 0, 0, new ArrayList<String>());
        }
        String[] documents = yamlContent.split("(?m)^---\\s*$");
        ArrayList<String> matchingDocuments = new ArrayList<String>();
        ArrayList<String> skippedKinds = new ArrayList<String>();
        int totalDocuments = 0;
        for (String document : documents) {
            String trimmedDoc = document.trim();
            if (trimmedDoc.isEmpty()) continue;
            ++totalDocuments;
            String kind = YamlKindFilter.extractKind(trimmedDoc);
            if (kind == null) {
                if (ctx != null) {
                    ctx.logError("  Warning: Document without 'kind' field found, skipping.");
                }
                skippedKinds.add("(no kind)");
                continue;
            }
            if (expectedKind.equalsIgnoreCase(kind)) {
                matchingDocuments.add(trimmedDoc);
                continue;
            }
            skippedKinds.add(kind);
        }
        StringBuilder filteredContent = new StringBuilder();
        for (int i = 0; i < matchingDocuments.size(); ++i) {
            if (i > 0) {
                filteredContent.append("\n---\n");
            } else {
                filteredContent.append("---\n");
            }
            filteredContent.append((String)matchingDocuments.get(i));
        }
        return new FilterResult(filteredContent.toString(), matchingDocuments.size(), totalDocuments, skippedKinds);
    }

    private static String extractKind(String document) {
        Matcher matcher = KIND_PATTERN.matcher(document);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    public static void logSkippedDocuments(FilterResult result, String yamlFileName, String expectedKind, ExecutionContext ctx) {
        if (result.hasSkippedDocuments()) {
            ctx.logError("  Warning: Found " + result.getSkippedKinds().size() + " document(s) with non-matching kind in " + yamlFileName);
            for (String skippedKind : result.getSkippedKinds()) {
                ctx.logError("    - Skipped document with kind: '" + skippedKind + "' (expected: '" + expectedKind + "')");
            }
        }
    }

    public static class FilterResult {
        private final String filteredContent;
        private final int matchingDocuments;
        private final int totalDocuments;
        private final List<String> skippedKinds;

        public FilterResult(String filteredContent, int matchingDocuments, int totalDocuments, List<String> skippedKinds) {
            this.filteredContent = filteredContent;
            this.matchingDocuments = matchingDocuments;
            this.totalDocuments = totalDocuments;
            this.skippedKinds = skippedKinds;
        }

        public String getFilteredContent() {
            return this.filteredContent;
        }

        public int getMatchingDocuments() {
            return this.matchingDocuments;
        }

        public int getTotalDocuments() {
            return this.totalDocuments;
        }

        public List<String> getSkippedKinds() {
            return this.skippedKinds;
        }

        public boolean hasContent() {
            return this.filteredContent != null && !this.filteredContent.trim().isEmpty();
        }

        public boolean hasSkippedDocuments() {
            return !this.skippedKinds.isEmpty();
        }
    }
}

