package ai.digital.deploy.gitops.util;

import java.io.Serializable;

/**
 * Simple data class to hold SCM (Source Control Management) information.
 * Used to pass SCM traceability data to the XLDAsCodeService without depending on xl-platform classes.
 */
public class SCMInfo implements Serializable {
    private static final long serialVersionUID = 1L;
    
    private final String kind;
    private final String commit;
    private final String author;
    private final String date;
    private final String message;
    private final String remote;
    private final String fileName;

    public SCMInfo(String kind, String commit, String author, String date, 
                   String message, String remote, String fileName) {
        this.kind = kind;
        this.commit = commit;
        this.author = author;
        this.date = date;
        this.message = message;
        this.remote = remote;
        this.fileName = fileName;
    }

    public String getKind() {
        return kind;
    }

    public String getCommit() {
        return commit;
    }

    public String getAuthor() {
        return author;
    }

    public String getDate() {
        return date;
    }

    public String getMessage() {
        return message;
    }

    public String getRemote() {
        return remote;
    }

    public String getFileName() {
        return fileName;
    }

    /**
     * Creates a new SCMInfo with a different filename.
     */
    public SCMInfo withFileName(String newFileName) {
        return new SCMInfo(kind, commit, author, date, message, remote, newFileName);
    }

    /**
     * Returns true if this SCMInfo has valid commit information.
     */
    public boolean hasCommit() {
        return commit != null && !commit.isEmpty();
    }

    @Override
    public String toString() {
        return "SCMInfo{" +
               "kind='" + kind + '\'' +
               ", commit='" + (commit != null ? commit.substring(0, Math.min(7, commit.length())) : "null") + '\'' +
               ", author='" + author + '\'' +
               ", remote='" + remote + '\'' +
               ", fileName='" + fileName + '\'' +
               '}';
    }
}
