/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import ai.digital.deploy.gitops.util.AsCodeResponseLogger;
import ai.digital.deploy.gitops.util.SCMInfo;
import ai.digital.deploy.gitops.util.SCMInfoExtractor;
import ai.digital.deploy.gitops.util.YamlKindFilter;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitApplyInfrastructureStep
implements Step {
    private static final String INFRASTRUCTURE_YAML = "infrastructure.yaml";
    private final String gitDirectoryId;

    public GitApplyInfrastructureStep(String gitDirectoryId) {
        this.gitDirectoryId = gitDirectoryId;
    }

    public String getDescription() {
        return "Import Infrastructure";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting Infrastructure import validation and apply");
        Object directoryAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (directoryAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Path directoryPath = Paths.get(directoryAttr.toString(), new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0]) || !Files.isDirectory(directoryPath, new LinkOption[0])) {
            ctx.logError("Directory missing or invalid: " + String.valueOf(directoryPath));
            return StepExitCode.FAIL;
        }
        Path infrastructureYamlPath = directoryPath.resolve(INFRASTRUCTURE_YAML);
        ctx.logOutput("Looking for infrastructure.yaml in: " + String.valueOf(directoryPath));
        if (!Files.exists(infrastructureYamlPath, new LinkOption[0])) {
            ctx.logError("infrastructure.yaml not found in directory: " + String.valueOf(directoryPath));
            ctx.logError("Please ensure the file exists or skip this step manually.");
            return StepExitCode.FAIL;
        }
        ctx.logOutput("Found infrastructure.yaml: " + String.valueOf(infrastructureYamlPath));
        return this.applyYamlFile(infrastructureYamlPath, ctx);
    }

    private StepExitCode applyYamlFile(Path yamlFile, ExecutionContext ctx) {
        XLDAsCodeService xldAsCodeService = ServiceHolder.getXLDAsCodeService();
        GitOpsServiceHolder.GitOpsServiceAdapter adapter = null;
        if (xldAsCodeService == null) {
            ctx.logOutput("XLDAsCodeService not available. Falling back to adapter.");
            adapter = GitOpsServiceHolder.getGitOpsService();
        }
        try {
            XLDAsCodeResult result;
            String yamlContent = new String(Files.readAllBytes(yamlFile));
            if (yamlContent.trim().isEmpty()) {
                ctx.logOutput("infrastructure.yaml is empty. Skipping.");
                return StepExitCode.SUCCESS;
            }
            this.checkMultipleSpecDirectories(yamlContent, ctx);
            ctx.logOutput("Validating YAML content for Infrastructure kind...");
            YamlKindFilter.FilterResult filterResult = YamlKindFilter.filterByKind(yamlContent, "Infrastructure", ctx);
            YamlKindFilter.logSkippedDocuments(filterResult, INFRASTRUCTURE_YAML, "Infrastructure", ctx);
            ctx.logOutput("  Found " + filterResult.getMatchingDocuments() + " of " + filterResult.getTotalDocuments() + " document(s) with kind: Infrastructure");
            if (!filterResult.hasContent()) {
                ctx.logError("No Infrastructure documents found in infrastructure.yaml.");
                ctx.logError("The file must contain at least one document with 'kind: Infrastructure'.");
                return StepExitCode.FAIL;
            }
            ctx.logOutput("Applying infrastructure.yaml (Infrastructure kind only)...");
            SCMInfo scmData = this.getSCMDataForFile(ctx, INFRASTRUCTURE_YAML);
            if (xldAsCodeService != null) {
                if (scmData != null && scmData.hasCommit()) {
                    ctx.logOutput("Applying with SCM traceability (commit: " + scmData.getCommit().substring(0, Math.min(7, scmData.getCommit().length())) + ")");
                    result = xldAsCodeService.applyWithScm(filterResult.getFilteredContent(), scmData.getKind(), scmData.getCommit(), scmData.getAuthor(), scmData.getDate(), scmData.getMessage(), scmData.getRemote(), scmData.getFileName());
                } else {
                    result = xldAsCodeService.apply(filterResult.getFilteredContent());
                }
            } else {
                result = adapter.apply(filterResult.getFilteredContent());
            }
            if (result.isSuccess()) {
                ctx.logOutput("Successfully applied infrastructure.yaml");
                AsCodeResponseLogger.logChanges(result, ctx);
                return StepExitCode.SUCCESS;
            }
            ctx.logError("Failed to apply infrastructure.yaml");
            ctx.logError("Reason: " + result.getMessage());
            if (result.getError() != null) {
                ctx.logError("Error: " + result.getError());
            }
            return StepExitCode.FAIL;
        }
        catch (Exception e) {
            ctx.logError("Exception processing infrastructure.yaml: " + e.getMessage());
            return StepExitCode.FAIL;
        }
    }

    private SCMInfo getSCMDataForFile(ExecutionContext ctx, String fileName) {
        Object scmAttr = ctx.getAttribute("gitOps.scmTraceabilityData");
        if (scmAttr instanceof SCMInfo) {
            SCMInfo baseSCM = (SCMInfo)scmAttr;
            return baseSCM.withFileName(fileName);
        }
        Object remoteUrlAttr = ctx.getAttribute("gitOps.gitRemoteUrl");
        if (remoteUrlAttr != null) {
            return SCMInfoExtractor.createMinimalSCMInfo(remoteUrlAttr.toString(), fileName);
        }
        return null;
    }

    private void checkMultipleSpecDirectories(String yamlContent, ExecutionContext ctx) {
        Pattern pattern = Pattern.compile("^\\s*-\\s*directory\\s*:", 8);
        Matcher matcher = pattern.matcher(yamlContent);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count > 1) {
            ctx.logError("Warning: Found " + count + " spec.directory entries in infrastructure.yaml. Multiple directory specifications detected. Proceeding with import.");
        }
    }

    public int getOrder() {
        return 20;
    }
}

