/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.DefaultGitOpsService;
import ai.digital.deploy.gitops.GitUserCredentials;
import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import ai.digital.deploy.gitops.util.YamlHandler;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@StepMetadata(name="gitClone")
public class GitCloneStep
implements SatelliteAware {
    private ConfigurationItem gitSource;
    private String targetDirectory;

    public GitCloneStep() {
    }

    public GitCloneStep(ConfigurationItem gitSource, String targetDirectory) {
        this.gitSource = gitSource;
        this.targetDirectory = targetDirectory;
    }

    public String getDescription() {
        return "Clone Git repository";
    }

    public int getOrder() {
        return 50;
    }

    public Satellite getSatellite() {
        return null;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String id = this.gitSource != null ? this.gitSource.getId() : "unknown";
        String url = this.gitSource != null ? (String)this.gitSource.getProperty("url") : "unknown";
        String branch = this.gitSource != null ? (String)this.gitSource.getProperty("branch") : "main";
        ctx.logOutput("Starting Git operation for source id: " + id);
        ctx.logOutput("Repository URL: " + url);
        ctx.logOutput("Branch: " + branch);
        try {
            String finalClonedDirectory;
            String operation;
            String actualTargetDirectory;
            String orgPrefixedRepoName = YamlHandler.createOrgPrefixedRepositoryName(url);
            if (this.targetDirectory == null || this.targetDirectory.trim().isEmpty()) {
                ctx.logOutput("Scenario 1: No target path specified - using temporary directory");
                String sanitizedRepoName = YamlHandler.sanitizeDirectoryName(orgPrefixedRepoName);
                Path tempDir = Files.createTempDirectory("git_source_" + sanitizedRepoName + "_", new FileAttribute[0]);
                actualTargetDirectory = tempDir.toAbsolutePath().toString();
                ctx.logOutput("Using org-prefixed repository name: " + orgPrefixedRepoName);
                ctx.logOutput("Created temporary directory: " + actualTargetDirectory);
                operation = "clone";
            } else {
                ctx.logOutput("Target path specified: " + this.targetDirectory);
                String repositoryPath = new File(this.targetDirectory, orgPrefixedRepoName).getAbsolutePath();
                ctx.logOutput("Using org-prefixed repository name: " + orgPrefixedRepoName);
                ctx.logOutput("Checking for existing repository at: " + repositoryPath);
                if (GitOpsServiceHolder.getGitOpsService().isGitRepository(repositoryPath)) {
                    ctx.logOutput("Scenario 3: Repository exists - performing pull operation");
                    actualTargetDirectory = repositoryPath;
                    operation = "pull";
                } else {
                    ctx.logOutput("Scenario 2: Repository doesn't exist - performing clone operation");
                    actualTargetDirectory = this.targetDirectory;
                    operation = "clone";
                }
            }
            ctx.logOutput("Operation: " + operation.toUpperCase());
            ctx.logOutput("Target directory: " + actualTargetDirectory);
            if ("clone".equals(operation)) {
                ctx.logOutput("Starting clone operation...");
                finalClonedDirectory = GitOpsServiceHolder.getGitOpsService().cloneRepository(this.gitSource, actualTargetDirectory);
                ctx.logOutput("Git repository cloned successfully to: " + finalClonedDirectory);
            } else if ("pull".equals(operation)) {
                ctx.logOutput("Starting pull operation...");
                finalClonedDirectory = GitOpsServiceHolder.getGitOpsService().pullRepository(actualTargetDirectory, this.extractCredentials(this.gitSource));
                ctx.logOutput("Git repository updated successfully at: " + finalClonedDirectory);
            } else {
                throw new RuntimeException("Unknown operation: " + operation);
            }
            this.logRepositoryInfo(ctx, finalClonedDirectory, operation);
            ctx.logOutput("Git " + operation + " operation completed successfully");
            return StepExitCode.SUCCESS;
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            ctx.logError("Failed to perform Git operation: " + errorMessage, (Throwable)exception);
            ctx.logError("Source ID: " + id);
            ctx.logError("Repository URL: " + url);
            ctx.logError("Target directory: " + this.targetDirectory);
            return StepExitCode.FAIL;
        }
    }

    private GitUserCredentials extractCredentials(ConfigurationItem gitSource) {
        if (gitSource == null) {
            return null;
        }
        try {
            String username = (String)gitSource.getProperty("username");
            String password = (String)gitSource.getProperty("password");
            if (username != null && !username.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
                return new GitUserCredentials(username, password);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void logRepositoryInfo(ExecutionContext ctx, String repositoryPath, String operation) {
        try {
            String actualFolderName = DefaultGitOpsService.extractFolderNameFromPath(repositoryPath);
            ctx.logOutput("Repository folder name: " + actualFolderName);
            File repoDir = new File(repositoryPath);
            if (repoDir.exists() && repoDir.isDirectory()) {
                File[] files = repoDir.listFiles();
                if (files != null && files.length > 0) {
                    ctx.logOutput("Repository contains " + files.length + " items");
                } else {
                    ctx.logOutput("Repository appears to be empty");
                }
            }
        }
        catch (Exception e) {
            ctx.logOutput("Warning: Could not read repository information: " + e.getMessage());
        }
    }
}

