/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.util.SCMInfo;
import ai.digital.deploy.gitops.util.SCMInfoExtractor;
import ai.digital.deploy.gitops.util.YamlHandler;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class GitRepositoryValidationStep
implements Step {
    private final String url;
    private final String username;
    private final String password;
    private final String gitRepositoryPath;
    private final String gitDirectoryId;
    private final String branch;

    public GitRepositoryValidationStep(String url, String username, String password, String gitRepositoryPath, String gitDirectoryId, String branch) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.gitRepositoryPath = gitRepositoryPath;
        this.gitDirectoryId = gitDirectoryId;
        this.branch = branch != null && !branch.isEmpty() ? branch : "main";
    }

    public String getDescription() {
        return "Validating Git Repository";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting Git repository validation");
        this.logAuthenticatedUser(ctx);
        ctx.logOutput("Git repository path: " + this.gitRepositoryPath);
        ctx.logOutput("Git directory ID: " + this.gitDirectoryId);
        ctx.logOutput("Git URL: " + this.url);
        ctx.logOutput("Branch: " + this.branch);
        String gitSourceUsername = this.username != null ? this.username : "unknown";
        ctx.logOutput("Git Source User: " + gitSourceUsername);
        String workspaceFolderName = YamlHandler.createGitRepoFolderName(this.gitDirectoryId, gitSourceUsername, this.url, this.branch);
        String serverHome = System.getProperty("user.dir");
        File gitReposDir = new File(serverHome, "work" + File.separator + "git_repos");
        File localRepoDir = new File(gitReposDir, workspaceFolderName);
        ctx.logOutput("Server home: " + serverHome);
        ctx.logOutput("Git repos directory: " + gitReposDir.getAbsolutePath());
        ctx.logOutput("Workspace folder name: " + workspaceFolderName);
        ctx.logOutput("Local repository directory: " + localRepoDir.getAbsolutePath());
        ctx.logOutput("Sparse checkout path: " + this.gitRepositoryPath);
        String idHash = YamlHandler.generateShortHash(this.gitDirectoryId);
        this.cleanupOldFoldersForSameGitDirectory(gitReposDir, idHash, workspaceFolderName, ctx);
        UsernamePasswordCredentialsProvider credentialsProvider = null;
        if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
            credentialsProvider = new UsernamePasswordCredentialsProvider(this.username, this.password);
        }
        if (!this.verifyPathExistsInRemote(this.url, this.branch, this.gitRepositoryPath, credentialsProvider, ctx)) {
            return StepExitCode.FAIL;
        }
        try (Git git = null;){
            if (localRepoDir.exists() && new File(localRepoDir, ".git").exists()) {
                ctx.logOutput("Repository already exists, performing git pull on sparse checkout...");
                git = Git.open((File)localRepoDir);
                PullResult pullResult = credentialsProvider != null ? ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setRemoteBranchName(this.branch).call() : git.pull().setRemoteBranchName(this.branch).call();
                ctx.logOutput("Pull result: " + (pullResult.isSuccessful() ? "SUCCESS" : "FAILED"));
            } else {
                ctx.logOutput("Performing sparse clone (only " + this.gitRepositoryPath + ")...");
                localRepoDir.mkdirs();
                git = Git.init().setDirectory(localRepoDir).call();
                File sparseCheckoutFile = new File(localRepoDir, ".git/info/sparse-checkout");
                sparseCheckoutFile.getParentFile().mkdirs();
                Files.write(sparseCheckoutFile.toPath(), (this.gitRepositoryPath + "/*\n").getBytes(), new OpenOption[0]);
                git.getRepository().getConfig().setBoolean("core", null, "sparseCheckout", true);
                git.getRepository().getConfig().save();
                git.remoteAdd().setName("origin").setUri(new URIish(this.url)).call();
                ctx.logOutput("Fetching from remote...");
                if (credentialsProvider != null) {
                    ((FetchCommand)git.fetch().setRemote("origin").setRefSpecs(new String[]{"+refs/heads/" + this.branch + ":refs/remotes/origin/" + this.branch}).setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
                } else {
                    git.fetch().setRemote("origin").setRefSpecs(new String[]{"+refs/heads/" + this.branch + ":refs/remotes/origin/" + this.branch}).call();
                }
                ctx.logOutput("Checking out branch: " + this.branch);
                git.checkout().setName(this.branch).setStartPoint("origin/" + this.branch).setCreateBranch(true).call();
                ctx.logOutput("Sparse clone completed successfully (only " + this.gitRepositoryPath + " directory)");
            }
            Path directoryPath = Paths.get(localRepoDir.getAbsolutePath(), this.gitRepositoryPath);
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                ctx.logError("Directory does not exist: " + String.valueOf(directoryPath));
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                ctx.logError("Path is not a directory: " + String.valueOf(directoryPath));
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            ctx.logOutput("Repository validation complete. Directory ready: " + String.valueOf(directoryPath));
            ctx.setAttribute("gitOps.localRepoDir", (Object)localRepoDir.getAbsolutePath());
            ctx.setAttribute("gitOps.targetDirectory", (Object)directoryPath.toString());
            ctx.setAttribute("gitOps.gitRemoteUrl", (Object)this.url);
            SCMInfo scmData = SCMInfoExtractor.extractSCMInfo(localRepoDir, "");
            if (scmData != null) {
                ctx.setAttribute("gitOps.scmTraceabilityData", (Object)scmData);
                ctx.logOutput("SCM Traceability: commit=" + scmData.getCommit().substring(0, Math.min(7, scmData.getCommit().length())) + ", author=" + scmData.getAuthor());
            } else {
                ctx.logOutput("SCM traceability data could not be extracted from repository");
            }
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
    }

    public int getOrder() {
        return 10;
    }

    private void cleanupOldFoldersForSameGitDirectory(File gitReposDir, String idHash, String currentFolderName, ExecutionContext ctx) {
        if (!gitReposDir.exists() || !gitReposDir.isDirectory()) {
            return;
        }
        String folderPrefix = "Folder_" + idHash + "_";
        File[] existingFolders = gitReposDir.listFiles();
        if (existingFolders == null) {
            return;
        }
        for (File folder : existingFolders) {
            if (!folder.isDirectory() || !folder.getName().startsWith(folderPrefix) || folder.getName().equals(currentFolderName)) continue;
            ctx.logOutput("Found old folder for different branch: " + folder.getName());
            ctx.logOutput("Deleting old folder to maintain single folder per gitDirectory...");
            try {
                this.deleteDirectoryRecursively(folder.toPath());
                ctx.logOutput("Successfully deleted old folder: " + folder.getName());
            }
            catch (Exception e) {
                ctx.logError("Warning: Failed to delete old folder " + folder.getName() + ": " + e.getMessage());
            }
        }
    }

    private void deleteDirectoryRecursively(Path path) throws Exception {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        ArrayList pathsToDelete = new ArrayList();
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(pathsToDelete::add);
        for (Path p : pathsToDelete) {
            try {
                File file = p.toFile();
                if (file.exists() && !file.canWrite()) {
                    file.setWritable(true);
                }
                Files.deleteIfExists(p);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(50L);
                    File file = p.toFile();
                    file.setWritable(true);
                    file.setReadable(true);
                    if (file.isDirectory()) {
                        file.delete();
                        continue;
                    }
                    Files.deleteIfExists(p);
                }
                catch (Exception e2) {
                    throw new Exception("Failed to delete: " + String.valueOf(p), e2);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean verifyPathExistsInRemote(String url, String branch, String path, UsernamePasswordCredentialsProvider credentialsProvider, ExecutionContext ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteDirectoryRecursively(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                this.deleteDirectoryRecursively(file);
            }
        }
        directory.delete();
    }

    private void logAuthenticatedUser(ExecutionContext ctx) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && authentication.getName() != null) {
                String xldUser = authentication.getName();
                ctx.logOutput("XLD Authenticated User: " + xldUser);
                ctx.logOutput("All CI changes will be performed under this user's permissions");
            } else {
                ctx.logOutput("XLD Authenticated User: unknown (no security context available)");
            }
        }
        catch (Exception e) {
            ctx.logOutput("XLD Authenticated User: could not determine (" + e.getMessage() + ")");
        }
    }
}

