/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.service;

import ai.digital.deploy.gitops.DefaultGitOpsService;
import ai.digital.deploy.gitops.GitOpsService;
import ai.digital.deploy.gitops.GitUserCredentials;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitOpsServiceHolder {
    private static final Logger logger = LoggerFactory.getLogger(GitOpsServiceHolder.class);
    private static final GitOpsServiceAdapter adapter = new GitOpsServiceAdapter();

    public static GitOpsServiceAdapter getGitOpsService() {
        return adapter;
    }

    public static XLDAsCodeService getService() {
        try {
            return ServiceHolder.getXLDAsCodeService();
        }
        catch (Exception e) {
            logger.debug("XLDAsCodeService not available: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static class GitOpsServiceAdapter {
        private final GitOpsService gitOpsService = new DefaultGitOpsService();

        public void checkConnection(ConfigurationItem gitSource) {
            GitConfig config = new GitConfig(gitSource);
            this.gitOpsService.testConnection(config.url, config.branch, config.credentials);
        }

        public String cloneRepository(ConfigurationItem gitSource, String targetDirectory) {
            GitConfig config = new GitConfig(gitSource);
            return this.gitOpsService.cloneRepository(config.url, config.branch, config.credentials, targetDirectory);
        }

        public String pullRepository(String repositoryPath, GitUserCredentials credentials) {
            return this.gitOpsService.pullRepository(repositoryPath, credentials);
        }

        public boolean isGitRepository(String directoryPath) {
            return this.gitOpsService.isGitRepository(directoryPath);
        }

        public String determineRepositoryPath(String url, String targetDirectory) {
            return this.gitOpsService.determineRepositoryPath(url, targetDirectory);
        }

        public XLDAsCodeResult apply(String yamlContent) {
            XLDAsCodeService xldAsCodeService = GitOpsServiceHolder.getService();
            if (xldAsCodeService != null) {
                try {
                    return xldAsCodeService.apply(yamlContent);
                }
                catch (Exception e) {
                    logger.error("Exception during YAML processing: {}", (Object)e.getMessage());
                    return new XLDAsCodeResult(false, "Exception during YAML processing: " + e.getMessage(), null, e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
            return new XLDAsCodeResult(false, "XLDAsCodeService not available in this environment", null, "ServiceHolder.getXLDAsCodeService() returned null");
        }

        private static class GitConfig {
            final String url;
            final String branch;
            final GitUserCredentials credentials;

            GitConfig(ConfigurationItem gitSource) {
                this.url = (String)gitSource.getProperty("url");
                this.branch = (String)gitSource.getProperty("branch");
                String username = (String)gitSource.getProperty("username");
                String password = (String)gitSource.getProperty("password");
                this.credentials = new GitUserCredentials(username, password);
            }
        }
    }
}

