/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;

public class GitYamlValidationStep
implements Step {
    private final String gitDirectoryId;

    public GitYamlValidationStep(String gitDirectoryId) {
        this.gitDirectoryId = gitDirectoryId;
    }

    public String getDescription() {
        return "Validating YAML";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        Object directoryAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (directoryAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Path directoryPath = Paths.get(directoryAttr.toString(), new String[0]);
        ctx.logOutput("Validating YAML files under: " + String.valueOf(directoryPath));
        if (!Files.exists(directoryPath, new LinkOption[0]) || !Files.isDirectory(directoryPath, new LinkOption[0])) {
            ctx.logError("Directory missing or invalid: " + String.valueOf(directoryPath));
            return StepExitCode.FAIL;
        }
        ArrayList yamlFiles = new ArrayList();
        try (Stream<Path> files = Files.walk(directoryPath, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".yaml") || p.toString().endsWith(".yml")).forEach(p -> {
                yamlFiles.add(p.toString());
                ctx.logOutput("Found YAML file: " + String.valueOf(p.getFileName()));
            });
        }
        if (yamlFiles.isEmpty()) {
            ctx.logOutput("No YAML files found under directory: " + String.valueOf(directoryPath));
            ctx.logOutput("Individual import steps will check for specific files.");
        } else {
            ctx.logOutput("Total YAML files found: " + yamlFiles.size());
        }
        ctx.setAttribute("gitOps.yamlFiles", yamlFiles);
        return StepExitCode.SUCCESS;
    }

    public int getOrder() {
        return 20;
    }
}

