/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops;

import ai.digital.deploy.gitops.step.CheckGitConnectionStep;
import ai.digital.deploy.gitops.step.GitApplyEnvironmentStep;
import ai.digital.deploy.gitops.step.GitApplyInfrastructureStep;
import ai.digital.deploy.gitops.step.GitCommitAndPushStep;
import ai.digital.deploy.gitops.step.GitGenerateEnvironmentStep;
import ai.digital.deploy.gitops.step.GitGenerateInfrastructureStep;
import ai.digital.deploy.gitops.step.GitRepositoryValidationStep;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public final class GitOpsDelegate {
    private GitOpsDelegate() {
    }

    @Delegate(name="gitOpsCheckConnection")
    public static List<Step> checkConnection(ConfigurationItem item, String name, Map<String, String> args, Parameters params) {
        return Lists.newArrayList((Object[])new Step[]{new CheckGitConnectionStep(item)});
    }

    @Delegate(name="gitOpsImportDirectory")
    public static List<Step> importDirectory(ConfigurationItem gitDirectory, String name, Map<String, String> args, Parameters params) {
        String directoryId;
        ConfigurationItem gitSource = (ConfigurationItem)gitDirectory.getProperty("gitSource");
        if (gitSource == null && (directoryId = gitDirectory.getId()) != null && directoryId.contains("/")) {
            int lastSlash = directoryId.lastIndexOf(47);
            String parentId = directoryId.substring(0, lastSlash);
            try {
                gitSource = ServiceHolder.getRepositoryService().read(parentId);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find parent GitSource with ID: " + parentId, e);
            }
        }
        String gitRepositoryPath = (String)gitDirectory.getProperty("gitRepositoryPath");
        String gitDirectoryId = gitDirectory.getId();
        String branch = (String)gitDirectory.getProperty("branch");
        String url = (String)gitSource.getProperty("url");
        String username = (String)gitSource.getProperty("username");
        String encryptedPassword = (String)gitSource.getProperty("password");
        String password = null;
        if (encryptedPassword != null && !encryptedPassword.isEmpty()) {
            password = PasswordEncrypter.getInstance().ensureDecrypted(encryptedPassword);
        }
        return Lists.newArrayList((Object[])new Step[]{new GitRepositoryValidationStep(url, username, password, gitRepositoryPath, gitDirectoryId, branch), new GitApplyInfrastructureStep(gitDirectoryId), new GitApplyEnvironmentStep(gitDirectoryId)});
    }

    @Delegate(name="gitOpsExportDirectory")
    public static List<Step> exportDirectory(ConfigurationItem gitDirectory, String name, Map<String, String> args, Parameters params) {
        Object tagToUse;
        String directoryId;
        ConfigurationItem gitSource = (ConfigurationItem)gitDirectory.getProperty("gitSource");
        if (gitSource == null && (directoryId = gitDirectory.getId()) != null && directoryId.contains("/")) {
            int lastSlash = directoryId.lastIndexOf(47);
            String parentId = directoryId.substring(0, lastSlash);
            try {
                gitSource = ServiceHolder.getRepositoryService().read(parentId);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find parent GitSource with ID: " + parentId, e);
            }
        }
        String gitRepositoryPath = (String)gitDirectory.getProperty("gitRepositoryPath");
        String gitDirectoryId = gitDirectory.getId();
        String branch = (String)gitDirectory.getProperty("branch");
        String infrastructureTargetDir = (String)gitDirectory.getProperty("infrastructureTargetDir");
        String environmentTargetDir = (String)gitDirectory.getProperty("environmentTargetDir");
        if (infrastructureTargetDir == null || infrastructureTargetDir.trim().isEmpty()) {
            throw new RuntimeException("Infrastructure Target Directory is mandatory for export. Please provide a value (e.g., 'Infrastructure/dev').");
        }
        if (environmentTargetDir == null || environmentTargetDir.trim().isEmpty()) {
            throw new RuntimeException("Environment Target Directory is mandatory for export. Please provide a value (e.g., 'Environments/prod').");
        }
        GitOpsDelegate.validatePathContainsCIs(infrastructureTargetDir, "Infrastructure Target Directory");
        GitOpsDelegate.validatePathContainsCIs(environmentTargetDir, "Environment Target Directory");
        String url = (String)gitSource.getProperty("url");
        String username = (String)gitSource.getProperty("username");
        String encryptedPassword = (String)gitSource.getProperty("password");
        String password = null;
        if (encryptedPassword != null && !encryptedPassword.isEmpty()) {
            password = PasswordEncrypter.getInstance().ensureDecrypted(encryptedPassword);
        }
        String tagName = null;
        if (params != null) {
            tagName = (String)params.getProperty("tagName");
        }
        if (tagName != null && !tagName.trim().isEmpty()) {
            tagToUse = tagName.trim();
            if (!GitOpsDelegate.isValidGitTagName((String)tagToUse)) {
                throw new RuntimeException("Invalid tag name: '" + (String)tagToUse + "'. Git tag names cannot contain spaces or special characters (~^:?*[]\\).");
            }
        } else {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter tagFormatter = DateTimeFormatter.ofPattern("yyMMdd-HHmm");
            tagToUse = "exp-" + now.format(tagFormatter);
        }
        GitOpsDelegate.validateTagNotExists(url, username, password, gitRepositoryPath, gitDirectoryId, branch, (String)tagToUse);
        return Lists.newArrayList((Object[])new Step[]{new GitRepositoryValidationStep(url, username, password, gitRepositoryPath, gitDirectoryId, branch), new GitGenerateInfrastructureStep(gitDirectoryId, infrastructureTargetDir), new GitGenerateEnvironmentStep(gitDirectoryId, environmentTargetDir), new GitCommitAndPushStep(gitDirectoryId, username, password, (String)tagToUse)});
    }

    private static void validateTagNotExists(String url, String username, String password, String gitRepositoryPath, String gitDirectoryId, String branch, String tagName) {
        try {
            UsernamePasswordCredentialsProvider credentials = username != null && !username.isEmpty() && password != null && !password.isEmpty() ? new UsernamePasswordCredentialsProvider(username, password) : null;
            Collection remoteTags = ((LsRemoteCommand)Git.lsRemoteRepository().setRemote(url).setTags(true).setCredentialsProvider(credentials)).call();
            String tagRefName = "refs/tags/" + tagName;
            for (Ref tagRef : remoteTags) {
                if (!tagRef.getName().equals(tagRefName)) continue;
                throw new RuntimeException("Tag '" + tagName + "' already exists in the repository. Enter a different tag name, or leave it blank to auto-generate one.");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void validatePathContainsCIs(String path, String fieldName) {
        if (path == null || path.trim().isEmpty()) {
            return;
        }
        List children = ServiceHolder.getRepositoryService().query(null, path.trim(), null, null, null, null, 0L, 1L);
        if (children == null || children.isEmpty()) {
            throw new RuntimeException(fieldName + " '" + path + "' is empty. No Configuration Items found to export.");
        }
    }

    private static boolean isValidGitTagName(String tagName) {
        if (tagName == null || tagName.isEmpty()) {
            return false;
        }
        String invalidPattern = ".*[~^:?*\\[\\]\\\\\\s].*";
        if (tagName.matches(invalidPattern)) {
            return false;
        }
        return !tagName.startsWith(".") && !tagName.endsWith(".") && !tagName.contains("..");
    }
}

