/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.util;

import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AsCodeResponseLogger {
    private static final Pattern CREATED_PATTERN = Pattern.compile("\"created\"\\s*:\\s*\\[([^\\]]*)]");
    private static final Pattern UPDATED_PATTERN = Pattern.compile("\"updated\"\\s*:\\s*\\[([^\\]]*)]");
    private static final Pattern DELETED_PATTERN = Pattern.compile("\"deleted\"\\s*:\\s*\\[([^\\]]*)]");
    private static final Pattern KIND_PATTERN = Pattern.compile("\"kind\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern ID_PATTERN = Pattern.compile("\"([^\"]+)\"");
    private static final Pattern ERRORS_BLOCK_PATTERN = Pattern.compile("\"errors\"\\s*:\\s*\\{([^}]+(?:\\{[^}]*\\}[^}]*)*)\\}");
    private static final Pattern VALIDATION_ARRAY_PATTERN = Pattern.compile("\"validation\"\\s*:\\s*\\[([^\\]]*(?:\\{[^}]*\\}[^\\]]*)*)\\]");
    private static final Pattern PERMISSION_ARRAY_PATTERN = Pattern.compile("\"permission\"\\s*:\\s*\\[([^\\]]*(?:\\{[^}]*\\}[^\\]]*)*)\\]");
    private static final Pattern DOCUMENT_PATTERN = Pattern.compile("\"document\"\\s*:\\s*\\{([^}]*)\\}");
    private static final Pattern GENERIC_PATTERN = Pattern.compile("\"generic\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern CI_ID_PATTERN = Pattern.compile("\"ciId\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\"propertyName\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\"message\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("\"permission\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern FIELD_PATTERN = Pattern.compile("\"field\"\\s*:\\s*\"([^\"]+)\"");
    private static final Pattern PROBLEM_PATTERN = Pattern.compile("\"problem\"\\s*:\\s*\"([^\"]+)\"");

    public static void logChanges(XLDAsCodeResult result, ExecutionContext ctx) {
        if (result == null || result.getContent() == null) {
            return;
        }
        String content = result.getContent();
        if (!content.startsWith("{")) {
            return;
        }
        try {
            String kind = AsCodeResponseLogger.extractKind(content);
            List<String> created = AsCodeResponseLogger.extractIds(content, CREATED_PATTERN);
            for (String string : created) {
                ctx.logOutput("    Created " + kind + " " + string);
            }
            List<String> updated = AsCodeResponseLogger.extractIds(content, UPDATED_PATTERN);
            for (String id : updated) {
                ctx.logOutput("    Updated " + kind + " " + id);
            }
            List<String> list = AsCodeResponseLogger.extractIds(content, DELETED_PATTERN);
            for (String id : list) {
                ctx.logOutput("    Deleted " + kind + " " + id);
            }
            AsCodeResponseLogger.logErrors(content, ctx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void logErrors(String content, ExecutionContext ctx) {
        String genericError;
        Matcher genericMatcher;
        Matcher documentMatcher;
        Matcher permissionMatcher;
        Matcher errorsMatcher = ERRORS_BLOCK_PATTERN.matcher(content);
        if (!errorsMatcher.find()) {
            return;
        }
        String errorsBlock = errorsMatcher.group(0);
        Matcher validationMatcher = VALIDATION_ARRAY_PATTERN.matcher(errorsBlock);
        if (validationMatcher.find()) {
            String[] validationErrors;
            String validationArray = validationMatcher.group(1);
            for (String error : validationErrors = validationArray.split("\\}\\s*,\\s*\\{")) {
                String ciId = AsCodeResponseLogger.extractField(error, CI_ID_PATTERN);
                String propertyName = AsCodeResponseLogger.extractField(error, PROPERTY_NAME_PATTERN);
                String message = AsCodeResponseLogger.extractField(error, MESSAGE_PATTERN);
                if (ciId == null && message == null) continue;
                ctx.logOutput("    Validation Error: " + (ciId != null ? ciId : "") + (String)(propertyName != null ? " [" + propertyName + "]" : "") + (String)(message != null ? " - " + message : ""));
            }
        }
        if ((permissionMatcher = PERMISSION_ARRAY_PATTERN.matcher(errorsBlock)).find()) {
            String[] permissionErrors;
            String permissionArray = permissionMatcher.group(1);
            for (String error : permissionErrors = permissionArray.split("\\}\\s*,\\s*\\{")) {
                String ciId = AsCodeResponseLogger.extractField(error, CI_ID_PATTERN);
                String permission = AsCodeResponseLogger.extractField(error, PERMISSION_PATTERN);
                if (ciId == null && permission == null) continue;
                ctx.logOutput("    Permission Error: " + (ciId != null ? ciId : "") + (String)(permission != null ? " - Missing permission: " + permission : ""));
            }
        }
        if ((documentMatcher = DOCUMENT_PATTERN.matcher(errorsBlock)).find()) {
            String documentError = documentMatcher.group(1);
            String field = AsCodeResponseLogger.extractField(documentError, FIELD_PATTERN);
            String problem = AsCodeResponseLogger.extractField(documentError, PROBLEM_PATTERN);
            if (field != null || problem != null) {
                ctx.logOutput("    Document Error: " + (String)(field != null ? "Field '" + field + "'" : "") + (String)(problem != null ? " - " + problem : ""));
            }
        }
        if ((genericMatcher = GENERIC_PATTERN.matcher(errorsBlock)).find() && (genericError = genericMatcher.group(1)) != null && !genericError.isEmpty()) {
            ctx.logOutput("    Error: " + genericError);
        }
    }

    private static String extractField(String json, Pattern pattern) {
        Matcher matcher = pattern.matcher(json);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String extractKind(String content) {
        Matcher matcher = KIND_PATTERN.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "CI";
    }

    private static List<String> extractIds(String content, Pattern arrayPattern) {
        String arrayContent;
        ArrayList<String> ids = new ArrayList<String>();
        Matcher arrayMatcher = arrayPattern.matcher(content);
        if (arrayMatcher.find() && (arrayContent = arrayMatcher.group(1)) != null && !arrayContent.trim().isEmpty()) {
            Matcher idMatcher = ID_PATTERN.matcher(arrayContent);
            while (idMatcher.find()) {
                ids.add(idMatcher.group(1));
            }
        }
        return ids;
    }

    public static boolean hasChanges(XLDAsCodeResult result) {
        if (result == null || result.getContent() == null) {
            return false;
        }
        String content = result.getContent();
        if (!content.startsWith("{")) {
            return false;
        }
        List<String> created = AsCodeResponseLogger.extractIds(content, CREATED_PATTERN);
        List<String> updated = AsCodeResponseLogger.extractIds(content, UPDATED_PATTERN);
        List<String> deleted = AsCodeResponseLogger.extractIds(content, DELETED_PATTERN);
        return !created.isEmpty() || !updated.isEmpty() || !deleted.isEmpty();
    }

    public static boolean hasErrors(XLDAsCodeResult result) {
        if (result == null || result.getContent() == null) {
            return false;
        }
        String content = result.getContent();
        if (!content.startsWith("{")) {
            return false;
        }
        return ERRORS_BLOCK_PATTERN.matcher(content).find();
    }
}

