/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.validation;

import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=GitDirectoryValidatorImpl.class, type="git-directory-validator")
@Target(value={ElementType.TYPE})
public @interface GitDirectoryValidator {

    public static class GitDirectoryValidatorImpl
    implements Validator<ConfigurationItem> {
        public void validate(ConfigurationItem ci, ValidationContext context) {
            String infrastructureTargetDir = (String)ci.getProperty("infrastructureTargetDir");
            String environmentTargetDir = (String)ci.getProperty("environmentTargetDir");
            if (infrastructureTargetDir != null && !infrastructureTargetDir.trim().isEmpty()) {
                this.validateTargetDirectory(infrastructureTargetDir.trim(), "Infrastructure", "Infrastructure Target Directory", context);
            }
            if (environmentTargetDir != null && !environmentTargetDir.trim().isEmpty()) {
                this.validateTargetDirectory(environmentTargetDir.trim(), "Environments", "Environment Target Directory", context);
            }
        }

        private void validateTargetDirectory(String targetDir, String rootPrefix, String fieldName, ValidationContext context) {
            if (!targetDir.startsWith(rootPrefix + "/")) {
                context.error("Invalid %s format: '%s'.The path must start with '%s/' (e.g., '%s/dev').", new Object[]{fieldName, targetDir, rootPrefix, rootPrefix});
                return;
            }
            long slashCount = targetDir.chars().filter(ch -> ch == 47).count();
            if (slashCount != 1L) {
                context.error("Invalid %s: '%s'.Only root-level folders can be exported (e.g., '%s/dev').  Subfolders won\u2019t be exported.", new Object[]{fieldName, targetDir, rootPrefix});
                return;
            }
            try {
                boolean exists = ServiceHolder.getRepositoryService().exists(targetDir);
                if (!exists) {
                    context.error("%s '%s' does not exist in Deploy repository. Choose an existing folder or create it first.", new Object[]{fieldName, targetDir});
                }
            }
            catch (Exception e) {
                context.error("Unable to verify if %s '%s' exists: %s", new Object[]{fieldName, targetDir, e.getMessage()});
            }
        }
    }
}

