/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.util;

import ai.digital.deploy.gitops.util.SCMInfo;
import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class SCMInfoExtractor {
    private static final String SCM_KIND_GIT = "git";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_INSTANT;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SCMInfo extractSCMInfo(File repoDir, String fileName) {
        if (repoDir == null) return null;
        if (!repoDir.exists()) {
            return null;
        }
        File gitDir = new File(repoDir, ".git");
        if (!gitDir.exists()) {
            return null;
        }
        try (Git git = Git.open((File)repoDir);){
            RevCommit headCommit;
            Repository repository = git.getRepository();
            ObjectId headId = repository.resolve("HEAD");
            if (headId == null) {
                SCMInfo sCMInfo2 = null;
                return sCMInfo2;
            }
            try (RevWalk revWalk = new RevWalk(repository);){
                headCommit = revWalk.parseCommit((AnyObjectId)headId);
            }
            String commitHash = headCommit.getName();
            PersonIdent authorIdent = headCommit.getAuthorIdent();
            String author = SCMInfoExtractor.formatAuthor(authorIdent);
            String date = SCMInfoExtractor.formatDate(authorIdent);
            String message = headCommit.getShortMessage();
            String remoteUrl = SCMInfoExtractor.getRemoteUrl(git);
            SCMInfo sCMInfo = new SCMInfo(SCM_KIND_GIT, commitHash, author, date, message, remoteUrl, fileName);
            return sCMInfo;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String formatAuthor(PersonIdent author) {
        if (author == null) {
            return "unknown";
        }
        String name = author.getName();
        String email = author.getEmailAddress();
        if (email != null && !email.isEmpty()) {
            return name + " <" + email + ">";
        }
        return name;
    }

    private static String formatDate(PersonIdent author) {
        if (author == null) {
            return "";
        }
        Instant instant = author.getWhen().toInstant();
        return DATE_FORMATTER.format(instant);
    }

    private static String getRemoteUrl(Git git) {
        try {
            List remotes = git.remoteList().call();
            for (RemoteConfig remote : remotes) {
                if (!"origin".equals(remote.getName()) || remote.getURIs().isEmpty()) continue;
                return ((URIish)remote.getURIs().get(0)).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static SCMInfo createMinimalSCMInfo(String remoteUrl, String fileName) {
        return new SCMInfo(SCM_KIND_GIT, "", "", "", "", remoteUrl != null ? remoteUrl : "", fileName);
    }
}

