/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.DefaultGitOpsService;
import ai.digital.deploy.gitops.GitUserCredentials;
import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import ai.digital.deploy.gitops.util.YamlHandler;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.File;

@StepMetadata(name="gitClone")
public class GitCloneStep
implements SatelliteAware {
    private ConfigurationItem gitSource;
    private String targetDirectory;

    public GitCloneStep() {
    }

    public GitCloneStep(ConfigurationItem gitSource, String targetDirectory) {
        this.gitSource = gitSource;
        this.targetDirectory = targetDirectory;
    }

    public String getDescription() {
        return "Clone Git repository";
    }

    public int getOrder() {
        return 50;
    }

    public Satellite getSatellite() {
        return null;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String id = this.gitSource != null ? this.gitSource.getId() : "unknown";
        String url = this.gitSource != null ? (String)this.gitSource.getProperty("url") : "unknown";
        String branch = this.gitSource != null ? (String)this.gitSource.getProperty("branch") : "main";
        ctx.logOutput("Starting Git operation for source id: " + id);
        ctx.logOutput("Repository URL: " + url);
        ctx.logOutput("Branch: " + branch);
        try {
            String finalClonedDirectory;
            String operation;
            String gitSourceUsername = this.gitSource != null ? (String)this.gitSource.getProperty("username") : null;
            String username = gitSourceUsername != null ? gitSourceUsername : "unknown";
            ctx.logOutput("Git Source User: " + username);
            String workspaceFolderName = YamlHandler.createGitRepoFolderName(id, username, url, branch);
            ctx.logOutput("Git Source ID: " + id);
            String serverHome = System.getProperty("user.dir");
            File gitReposDir = new File(serverHome, "work" + File.separator + "git_repos");
            File localRepoDir = new File(gitReposDir, workspaceFolderName);
            ctx.logOutput("Server home: " + serverHome);
            ctx.logOutput("Git repos directory: " + gitReposDir.getAbsolutePath());
            ctx.logOutput("Workspace folder name: " + workspaceFolderName);
            String actualTargetDirectory = localRepoDir.getAbsolutePath();
            if (GitOpsServiceHolder.getGitOpsService().isGitRepository(actualTargetDirectory)) {
                ctx.logOutput("Repository exists - performing pull operation");
                operation = "pull";
            } else {
                ctx.logOutput("Repository doesn't exist - performing clone operation");
                operation = "clone";
            }
            ctx.logOutput("Operation: " + operation.toUpperCase());
            ctx.logOutput("Target directory: " + actualTargetDirectory);
            if ("clone".equals(operation)) {
                ctx.logOutput("Starting clone operation...");
                finalClonedDirectory = GitOpsServiceHolder.getGitOpsService().cloneRepository(this.gitSource, actualTargetDirectory);
                ctx.logOutput("Git repository cloned successfully to: " + finalClonedDirectory);
            } else if ("pull".equals(operation)) {
                ctx.logOutput("Starting pull operation...");
                finalClonedDirectory = GitOpsServiceHolder.getGitOpsService().pullRepository(actualTargetDirectory, this.extractCredentials(this.gitSource));
                ctx.logOutput("Git repository updated successfully at: " + finalClonedDirectory);
            } else {
                throw new RuntimeException("Unknown operation: " + operation);
            }
            this.logRepositoryInfo(ctx, finalClonedDirectory, operation);
            ctx.logOutput("Git " + operation + " operation completed successfully");
            return StepExitCode.SUCCESS;
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            ctx.logError("Failed to perform Git operation: " + errorMessage, (Throwable)exception);
            ctx.logError("Source ID: " + id);
            ctx.logError("Repository URL: " + url);
            ctx.logError("Target directory: " + this.targetDirectory);
            return StepExitCode.FAIL;
        }
    }

    private GitUserCredentials extractCredentials(ConfigurationItem gitSource) {
        if (gitSource == null) {
            return null;
        }
        try {
            String username = (String)gitSource.getProperty("username");
            String password = (String)gitSource.getProperty("password");
            if (username != null && !username.trim().isEmpty() && password != null && !password.trim().isEmpty()) {
                return new GitUserCredentials(username, password);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void logRepositoryInfo(ExecutionContext ctx, String repositoryPath, String operation) {
        try {
            String actualFolderName = DefaultGitOpsService.extractFolderNameFromPath(repositoryPath);
            ctx.logOutput("Repository folder name: " + actualFolderName);
            File repoDir = new File(repositoryPath);
            if (repoDir.exists() && repoDir.isDirectory()) {
                File[] files = repoDir.listFiles();
                if (files != null && files.length > 0) {
                    ctx.logOutput("Repository contains " + files.length + " items");
                } else {
                    ctx.logOutput("Repository appears to be empty");
                }
            }
        }
        catch (Exception e) {
            ctx.logError("Warning: Could not read repository information: " + e.getMessage());
        }
    }
}

