/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitCommitAndPushStep
implements Step {
    private static final String INFRASTRUCTURE_YAML = "infrastructure.yaml";
    private static final String ENVIRONMENT_YAML = "environment.yaml";
    private final String gitDirectoryId;
    private final String username;
    private final String password;
    private final String tagName;
    private final String commitMessage;
    private final String remoteUrl;
    private final String branch;
    private final String gitRepositoryPath;
    private final String infrastructureSourceDir;
    private final String environmentSourceDir;

    public GitCommitAndPushStep(String gitDirectoryId, String username, String password, String tagName, String commitMessage, String remoteUrl, String branch, String gitRepositoryPath, String infrastructureSourceDir, String environmentSourceDir) {
        this.gitDirectoryId = gitDirectoryId;
        this.username = username;
        this.password = password;
        this.tagName = tagName;
        this.commitMessage = commitMessage;
        this.remoteUrl = remoteUrl;
        this.branch = branch;
        this.gitRepositoryPath = gitRepositoryPath;
        this.infrastructureSourceDir = infrastructureSourceDir;
        this.environmentSourceDir = environmentSourceDir;
    }

    public String getDescription() {
        return "Commit and Push to Git";
    }

    public int getOrder() {
        return 40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        Object localRepoDirAttr = ctx.getAttribute("gitOps.localRepoDir");
        if (localRepoDirAttr == null) {
            ctx.logError("Local repository directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Object targetDirAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (targetDirAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        File localRepoDir = new File(localRepoDirAttr.toString());
        Path targetDirectory = Paths.get(targetDirAttr.toString(), new String[0]);
        try (Git git = null;){
            String author;
            git = Git.open((File)localRepoDir);
            Path repoPath = localRepoDir.toPath();
            Path relativeTarget = repoPath.relativize(targetDirectory);
            String infrastructureRelPath = relativeTarget.resolve(INFRASTRUCTURE_YAML).toString().replace('\\', '/');
            String environmentRelPath = relativeTarget.resolve(ENVIRONMENT_YAML).toString().replace('\\', '/');
            AddCommand addCommand = git.add();
            addCommand.addFilepattern(infrastructureRelPath);
            addCommand.addFilepattern(environmentRelPath);
            addCommand.call();
            Status status = git.status().call();
            HashSet staged = new HashSet(status.getAdded());
            staged.addAll(status.getChanged());
            ArrayList<String> filesChanged = new ArrayList<String>();
            if (staged.isEmpty() && status.getModified().isEmpty()) {
                ctx.logOutput("No changes detected. Nothing to commit.");
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            for (String file : staged) {
                filesChanged.add(file);
            }
            for (String file : status.getModified()) {
                git.add().addFilepattern(file).call();
                filesChanged.add(file);
            }
            CommitCommand commitCommand = git.commit();
            commitCommand.setMessage(this.commitMessage);
            String string = author = this.username != null && !this.username.isEmpty() ? this.username : "xldeploy";
            if (this.username != null && !this.username.isEmpty()) {
                commitCommand.setAuthor(this.username, this.username + "@xldeploy.local");
                commitCommand.setCommitter(this.username, this.username + "@xldeploy.local");
            }
            RevCommit commit = commitCommand.call();
            String commitId = commit.getId().getName();
            boolean tagCreated = false;
            if (this.tagName != null && !this.tagName.isEmpty()) {
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                String tagMessage = String.format("XLD Export at %s", timestamp);
                git.tag().setName(this.tagName).setMessage(tagMessage).setAnnotated(true).call();
                tagCreated = true;
            }
            PushCommand pushCommand = git.push();
            if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
                pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password));
            }
            Iterable pushResults = pushCommand.call();
            boolean pushSuccess = true;
            for (PushResult pushResult : pushResults) {
                for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                    RemoteRefUpdate.Status updateStatus = update.getStatus();
                    if (updateStatus == RemoteRefUpdate.Status.OK || updateStatus == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                    pushSuccess = false;
                    ctx.logError("Push failed: " + update.getMessage());
                }
            }
            if (tagCreated) {
                PushCommand pushTagsCommand = git.push().setPushTags();
                if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
                    pushTagsCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.username, this.password));
                }
                Iterable tagPushResults = pushTagsCommand.call();
                for (PushResult pushResult : tagPushResults) {
                    for (RemoteRefUpdate update : pushResult.getRemoteUpdates()) {
                        RemoteRefUpdate.Status updateStatus = update.getStatus();
                        if (updateStatus == RemoteRefUpdate.Status.OK || updateStatus == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                        ctx.logError("Tag push failed: " + update.getMessage());
                        pushSuccess = false;
                    }
                }
            }
            if (pushSuccess) {
                String displayUrl = this.maskCredentialsInUrl(this.remoteUrl);
                ctx.logOutput("");
                ctx.logOutput("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                ctx.logOutput("                    EXPORT SUMMARY                      ");
                ctx.logOutput("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                ctx.logOutput("  Status         : SUCCESS");
                ctx.logOutput("  Pushed by      : " + author);
                ctx.logOutput("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                ctx.logOutput("  GIT DETAILS");
                ctx.logOutput("  Remote         : " + displayUrl);
                ctx.logOutput("  Branch         : " + this.branch);
                ctx.logOutput("  Repo Path      : " + this.gitRepositoryPath);
                ctx.logOutput("  Commit ID      : " + commitId);
                ctx.logOutput("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                ctx.logOutput("  EXPORTED FROM XL DEPLOY");
                ctx.logOutput("  Infrastructure : " + this.infrastructureSourceDir);
                ctx.logOutput("  Environments   : " + this.environmentSourceDir);
                ctx.logOutput("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                ctx.logOutput("  FILES CHANGED (" + filesChanged.size() + "):");
                for (String file : filesChanged) {
                    ctx.logOutput("    \u2022 " + file);
                }
                ctx.logOutput("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                ctx.logOutput("  Commit Message : " + this.commitMessage);
                if (tagCreated) {
                    ctx.logOutput("  Tag Created    : " + this.tagName);
                } else {
                    ctx.logOutput("  Tag Created    : (none)");
                }
                ctx.logOutput("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                ctx.logOutput("");
                StepExitCode stepExitCode = StepExitCode.SUCCESS;
                return stepExitCode;
            }
            ctx.logError("Push to remote repository failed");
            StepExitCode stepExitCode = StepExitCode.FAIL;
            return stepExitCode;
        }
    }

    private String maskCredentialsInUrl(String url) {
        if (url == null) {
            return "(unknown)";
        }
        return url.replaceAll("(https?://)([^:@]+)(:[^@]+)?@", "$1***@");
    }
}

