/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.step;

import ai.digital.deploy.gitops.service.GitOpsServiceHolder;
import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GitGenerateInfrastructureStep
implements Step {
    private static final String INFRASTRUCTURE_YAML = "infrastructure.yaml";
    private final String gitDirectoryId;
    private final String infrastructureSourceDir;

    public GitGenerateInfrastructureStep(String gitDirectoryId, String infrastructureSourceDir) {
        this.gitDirectoryId = gitDirectoryId;
        this.infrastructureSourceDir = infrastructureSourceDir;
    }

    public String getDescription() {
        return "Export Infrastructure";
    }

    public int getOrder() {
        return 20;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Starting Infrastructure export");
        ctx.logOutput("Infrastructure source directory: " + this.infrastructureSourceDir);
        Object directoryAttr = ctx.getAttribute("gitOps.targetDirectory");
        if (directoryAttr == null) {
            ctx.logError("Target directory not found in context. Did the repository validation step run?");
            return StepExitCode.FAIL;
        }
        Path directoryPath = Paths.get(directoryAttr.toString(), new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0]) || !Files.isDirectory(directoryPath, new LinkOption[0])) {
            ctx.logError("Directory missing or invalid: " + String.valueOf(directoryPath));
            return StepExitCode.FAIL;
        }
        Path infrastructureYamlPath = directoryPath.resolve(INFRASTRUCTURE_YAML);
        ctx.logOutput("Will generate infrastructure.yaml at: " + String.valueOf(infrastructureYamlPath));
        return this.generateYamlFile(infrastructureYamlPath, ctx);
    }

    private StepExitCode generateYamlFile(Path yamlFile, ExecutionContext ctx) {
        XLDAsCodeService xldAsCodeService = ServiceHolder.getXLDAsCodeService();
        GitOpsServiceHolder.GitOpsServiceAdapter adapter = null;
        if (xldAsCodeService == null) {
            ctx.logOutput("XLDAsCodeService not available. Falling back to adapter.");
            adapter = GitOpsServiceHolder.getGitOpsService();
        }
        try {
            String fullPath = this.ensureInfrastructurePath(this.infrastructureSourceDir);
            ctx.logOutput("Generating YAML from path: " + fullPath);
            XLDAsCodeResult result = xldAsCodeService != null ? xldAsCodeService.generate(fullPath, false, false, false, false, false) : adapter.generate(fullPath, false, false, false, false, false);
            if (result == null) {
                ctx.logError("Generate returned null result for path: " + fullPath);
                return StepExitCode.FAIL;
            }
            if (!result.isSuccess()) {
                ctx.logError("Failed to generate YAML: " + (result.getError() != null ? result.getError() : "Unknown error"));
                return StepExitCode.FAIL;
            }
            Object yamlContent = result.getContent();
            if (yamlContent == null || ((String)yamlContent).trim().isEmpty()) {
                ctx.logOutput("No CIs found in " + this.infrastructureSourceDir + ". Creating empty infrastructure.yaml.");
                yamlContent = "# No infrastructure CIs found in " + this.infrastructureSourceDir + "\n";
            }
            Files.write(yamlFile, ((String)yamlContent).getBytes(), new OpenOption[0]);
            ctx.logOutput("Successfully generated infrastructure.yaml with " + ((String)yamlContent).length() + " bytes");
            if (result.getMessage() != null && !result.getMessage().isEmpty()) {
                ctx.logOutput("Generation message: " + result.getMessage());
            }
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            ctx.logError("Failed to generate infrastructure.yaml: " + e.getMessage(), (Throwable)e);
            return StepExitCode.FAIL;
        }
    }

    private String ensureInfrastructurePath(String path) {
        if (path == null || path.trim().isEmpty()) {
            return path;
        }
        String trimmedPath = path.trim();
        if (trimmedPath.startsWith("Infrastructure/") || trimmedPath.equals("Infrastructure")) {
            return trimmedPath;
        }
        return "Infrastructure/" + trimmedPath;
    }
}

