/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.gitops.validation;

import com.xebialabs.deployit.engine.api.ServiceHolder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=GitDirectoryValidatorImpl.class, type="git-directory-validator")
@Target(value={ElementType.TYPE})
public @interface GitDirectoryValidator {

    public static class GitDirectoryValidatorImpl
    implements Validator<ConfigurationItem> {
        public void validate(ConfigurationItem ci, ValidationContext context) {
            String infrastructureSourceDir = (String)ci.getProperty("infrastructureSourceDir");
            String environmentSourceDir = (String)ci.getProperty("environmentSourceDir");
            if (infrastructureSourceDir != null && !infrastructureSourceDir.trim().isEmpty()) {
                this.validateSourceDirectory(infrastructureSourceDir.trim(), "Infrastructure", "Infrastructure Source Directory", context);
            }
            if (environmentSourceDir != null && !environmentSourceDir.trim().isEmpty()) {
                this.validateSourceDirectory(environmentSourceDir.trim(), "Environments", "Environment Source Directory", context);
            }
        }

        private void validateSourceDirectory(String sourceDir, String rootPrefix, String fieldName, ValidationContext context) {
            long slashCount;
            if (!sourceDir.startsWith(rootPrefix + "/")) {
                context.error("Invalid %s format: '%s'.The path must start with '%s/' (e.g., '%s/dev').", new Object[]{fieldName, sourceDir, rootPrefix, rootPrefix});
            }
            if ((slashCount = sourceDir.chars().filter(ch -> ch == 47).count()) != 1L) {
                context.error("Invalid %s: '%s'.Only root-level folders can be exported (e.g., '%s/dev').  Subfolders won't be exported.", new Object[]{fieldName, sourceDir, rootPrefix});
                return;
            }
            try {
                boolean exists = ServiceHolder.getRepositoryService().exists(sourceDir);
                if (!exists) {
                    context.error("%s '%s' does not exist in Deploy repository. Choose an existing folder or create it first.", new Object[]{fieldName, sourceDir});
                }
            }
            catch (Exception e) {
                context.error("Unable to verify if %s '%s' exists: %s", new Object[]{fieldName, sourceDir, e.getMessage()});
            }
        }
    }
}

