/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PowerShellStepUtils {
    private static final String DEFAULT_POWER_SHELL_PATH = "powershell";
    private static Logger logger = LoggerFactory.getLogger(PowerShellStepUtils.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.powershell.scripts");

    public static Preview previewPowerShellScript(PowerShellScriptCallback callback) {
        try (OverthereConnection poc = PreviewOverthereConnection.getPreviewConnection();){
            String scriptPath = callback.getScriptPath();
            String generatedScript = callback.generateScript(poc);
            Preview preview = Preview.withSourcePathAndContents((String)scriptPath, (String)generatedScript);
            return preview;
        }
    }

    public static StepExitCode executePowerShellScript(HostContainer container, ExecutionContext ctx, PowerShellScriptCallback callback, PowerShellScriptCallback obfuscationCallback) throws Exception {
        String scriptPath = callback.getScriptPath();
        MDC.put((String)"scriptPath", (String)scriptPath);
        try {
            StepExitCode stepExitCode;
            block14: {
                OverthereConnection conn;
                block12: {
                    StepExitCode stepExitCode2;
                    block13: {
                        conn = container.getHost().getConnection();
                        try {
                            String generatedScript = callback.generateScript(conn);
                            if (scriptsLogger.isTraceEnabled()) {
                                String obfuscatedScript = obfuscationCallback.generateScript(conn);
                                ScriptUtils.dumpScript((String)OverthereUtils.getName((String)scriptPath), (String)obfuscatedScript, (Logger)scriptsLogger);
                            }
                            OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)scriptPath, (String)generatedScript);
                            callback.uploadAdditionalResources(container, ctx, conn);
                            int res = PowerShellStepUtils.executePowerShellScript(container, ctx, conn, uploadedScriptFile);
                            logger.debug("Exit code: [{}]", (Object)res);
                            if (res != 0) break block12;
                            stepExitCode2 = StepExitCode.SUCCESS;
                            if (conn == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (conn != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        conn.close();
                    }
                    return stepExitCode2;
                }
                stepExitCode = StepExitCode.FAIL;
                if (conn == null) break block14;
                conn.close();
            }
            return stepExitCode;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    private static int executePowerShellScript(HostContainer container, ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        logger.info("Executing PowerShell script [{}] on [{}]", (Object)script, (Object)conn);
        try (DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)ctx);){
            int n;
            block12: {
                DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)ctx);
                try {
                    CmdLine cmdLine = PowerShellStepUtils.getScriptCommandLine(container, script);
                    n = conn.execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, cmdLine);
                    if (stderrHandler == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stderrHandler != null) {
                        try {
                            stderrHandler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stderrHandler.close();
            }
            return n;
        }
    }

    public static CmdLine getScriptCommandLine(HostContainer container, OverthereFile script) {
        CmdLine cmdLine = container instanceof PowerShellContainer ? ((PowerShellContainer)container).getScriptCommandLine(script) : PowerShellStepUtils.getDefaultScriptCommandLine(DEFAULT_POWER_SHELL_PATH, script);
        return cmdLine;
    }

    public static CmdLine getDefaultScriptCommandLine(String powerShellPath, OverthereFile script) {
        return CmdLine.build((String[])new String[]{powerShellPath, "-ExecutionPolicy", "Unrestricted", "-Inputformat", "None", "-NonInteractive", "-NoProfile", "-Command", "$ErrorActionPreference = 'Stop'; & " + script.getPath() + "; if($LastExitCode) { Exit $LastExitCode; }"});
    }

    static interface PowerShellScriptCallback {
        public String getScriptPath();

        public String generateScript(OverthereConnection var1);

        public void uploadAdditionalResources(HostContainer var1, ExecutionContext var2, OverthereConnection var3);
    }
}

