package com.xebialabs.deployit.plugin.powershell.delegate

import java.util.{List => JList, Map => JMap}

import com.google.common.base.Strings.isNullOrEmpty
import com.xebialabs.deployit.plugin.api.creator.CreatorContext
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.Delegate.Use
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Delegate, Parameters}
import com.xebialabs.deployit.plugin.powershell.{BasePowerShellContainer, PowerShellDeploymentStep}

import scala.jdk.CollectionConverters._

object PowershellDelegate {

  @Delegate(name = "powershellScript")
  def powershellScriptDelegate(item: ConfigurationItem, name: String, args: JMap[String, String], params: Parameters): JList[Step] = {
    val script = args.get("script")
    require(!isNullOrEmpty(script), "Argument 'script' is required.")
    println(item.getType.getDescriptor.getSuperClasses)
    require(item.isInstanceOf[BasePowerShellContainer], s"'${item.getId}' of type '${item.getType.toString}' do not extend BasePowerShellContainer.")

    val container = item.asInstanceOf[BasePowerShellContainer].getHost
    val context = Map(
      "thisCi" -> item,
      "args" -> args,
      "params" -> params)

    val desc = if (args.containsKey("description")) {
      args.get("description")
    } else {
      s"Executing control task $name on ${item.getId}"
    }
    List[Step](new PowerShellDeploymentStep(1, container, null, script, context.asJava, desc)).asJava
  }

  @Delegate(use = Use.CREATOR, name = "powershellScript")
  def jythonScriptCreatorDelegate(context: CreatorContext, args: JMap[String, String]): Unit =
    throw new IllegalStateException("Powershell script creator is not supported")

}
