/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.BaseExtensiblePowerShellDeployed;
import com.xebialabs.deployit.plugin.powershell.PowerShellBatchDeploymentStep;
import com.xebialabs.deployit.plugin.powershell.PowerShellDeploymentStep;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PowerShellBatchContributor {
    public static final int MAX_DESCRIPTION_LENGTH = 50;
    private static Logger logger = LoggerFactory.getLogger(PowerShellBatchContributor.class);

    private PowerShellBatchContributor() {
    }

    @Contributor
    public static void generateCombinedSteps(Deltas deltas, DeploymentPlanningContext ctx) {
        logger.debug("Begin");
        Multimap<HostContainer, Delta> deltasPerContainer = PowerShellBatchContributor.getDeltasPerContainer(deltas);
        PowerShellBatchContributor.generateStepsPerContainer(deltasPerContainer, ctx);
        logger.debug("End");
    }

    private static Multimap<HostContainer, Delta> getDeltasPerContainer(Deltas deltas) {
        logger.debug("Finding deltas to batch");
        ArrayListMultimap deltasPerContainer = ArrayListMultimap.create();
        for (Delta d : deltas.getDeltas()) {
            Deployed<?, ?> deployed = PowerShellBatchContributor.getActiveDeployed(d);
            if (!(deployed instanceof BaseExtensiblePowerShellDeployed)) continue;
            BaseExtensiblePowerShellDeployed pd = (BaseExtensiblePowerShellDeployed)deployed;
            if (pd.shouldBatch()) {
                logger.debug("Adding BaseExtensiblePowerShellDeployed [{}] to batch", (Object)pd.getId());
                deltasPerContainer.put((Object)((HostContainer)pd.getContainer()), (Object)d);
                continue;
            }
            logger.debug("NOT adding BaseExtensiblePowerShellDeployed [{}] to batch", (Object)pd.getId());
        }
        logger.debug("Found " + deltasPerContainer.size() + " deltas to batch");
        return deltasPerContainer;
    }

    private static void generateStepsPerContainer(Multimap<HostContainer, Delta> deltasPerContainer, DeploymentPlanningContext ctx) {
        logger.debug("Generating batch steps");
        for (HostContainer container : deltasPerContainer.keySet()) {
            Collection deltas = deltasPerContainer.get((Object)container);
            PowerShellBatchContributor.generateStepsForContainer(container, deltas, ctx);
        }
    }

    private static void generateStepsForContainer(HostContainer container, Collection<Delta> deltas, DeploymentPlanningContext ctx) {
        logger.debug("Generating batch steps for container [{}]", (Object)container.getId());
        ArrayListMultimap batchGroups = ArrayListMultimap.create();
        int maxBatchSize = PowerShellBatchContributor.generateSingleSteps(deltas, ctx, (ListMultimap<BatchGroup, BatchElement>)batchGroups);
        PowerShellBatchContributor.generateBatchSteps(container, ctx, (ListMultimap<BatchGroup, BatchElement>)batchGroups, maxBatchSize);
    }

    private static int generateSingleSteps(Collection<Delta> deltas, DeploymentPlanningContext ctx, ListMultimap<BatchGroup, BatchElement> batchGroups) {
        logger.debug("Generating component steps");
        int maxBatchSize = -1;
        for (Delta d : deltas) {
            BatchElement e;
            BatchGroup b;
            BaseExtensiblePowerShellDeployed pd = (BaseExtensiblePowerShellDeployed)PowerShellBatchContributor.getActiveDeployed(d);
            if (maxBatchSize == -1 || pd.maxBatchSize < maxBatchSize) {
                maxBatchSize = pd.maxBatchSize;
                logger.debug("Setting maxBatchSize={}", (Object)maxBatchSize);
            }
            if ((d.getOperation() == Operation.DESTROY && pd.stopOnDestroy || d.getOperation() == Operation.MODIFY && pd.stopStartOnModify || d.getOperation() == Operation.NOOP && pd.stopStartOnNoop) && !Strings.isNullOrEmpty((String)pd.stopScript)) {
                b = new BatchGroup(pd.stopOrder, pd.stopVerb);
                e = new BatchElement(pd.createStep(ctx, d, pd.stopOrder, pd.stopScript, pd.stopVerb, pd.stopOptions));
                logger.debug("Adding {} to {} for stop", (Object)e, (Object)b);
                batchGroups.put((Object)b, (Object)e);
            }
            if ((d.getOperation() == Operation.DESTROY || d.getOperation() == Operation.MODIFY && Strings.isNullOrEmpty((String)pd.modifyScript)) && !Strings.isNullOrEmpty((String)pd.destroyScript)) {
                b = new BatchGroup(pd.destroyOrder, pd.destroyVerb);
                e = new BatchElement(pd.createStep(ctx, d, pd.destroyOrder, pd.destroyScript, pd.destroyVerb, pd.destroyOptions), d, Operation.DESTROY);
                logger.debug("Adding {} to {} for destroy", (Object)e, (Object)b);
                batchGroups.put((Object)b, (Object)e);
            }
            if ((d.getOperation() == Operation.CREATE || d.getOperation() == Operation.MODIFY && Strings.isNullOrEmpty((String)pd.modifyScript)) && !Strings.isNullOrEmpty((String)pd.createScript)) {
                b = new BatchGroup(pd.createOrder, pd.createVerb);
                e = new BatchElement(pd.createStep(ctx, d, pd.createOrder, pd.createScript, pd.createVerb, pd.createOptions), d, Operation.CREATE);
                logger.debug("Adding {} to {} for create", (Object)e, (Object)b);
                batchGroups.put((Object)b, (Object)e);
            }
            if (d.getOperation() == Operation.MODIFY && !Strings.isNullOrEmpty((String)pd.modifyScript)) {
                b = new BatchGroup(pd.modifyOrder, pd.modifyVerb);
                e = new BatchElement(pd.createStep(ctx, d, pd.modifyOrder, pd.modifyScript, pd.modifyVerb, pd.modifyOptions), d, Operation.MODIFY);
                logger.debug("Adding {} to {} for modify", (Object)e, (Object)b);
                batchGroups.put((Object)b, (Object)e);
            }
            if (!(d.getOperation() == Operation.CREATE && pd.startOnCreate || d.getOperation() == Operation.MODIFY && pd.stopStartOnModify) && (d.getOperation() != Operation.NOOP || !pd.stopStartOnNoop) || Strings.isNullOrEmpty((String)pd.startScript)) continue;
            b = new BatchGroup(pd.startOrder, pd.startVerb);
            e = new BatchElement(pd.createStep(ctx, d, pd.startOrder, pd.startScript, pd.startVerb, pd.startOptions));
            logger.debug("Adding {} to {} for start", (Object)e, (Object)b);
            batchGroups.put((Object)b, (Object)e);
        }
        return maxBatchSize;
    }

    private static void generateBatchSteps(HostContainer container, DeploymentPlanningContext ctx, ListMultimap<BatchGroup, BatchElement> batchGroups, int maxBatchSize) {
        logger.debug("Grouping component steps into batch steps (with maxBatchSize = {})", (Object)maxBatchSize);
        for (BatchGroup batchGroup : batchGroups.keySet()) {
            List elements = batchGroups.get((Object)batchGroup);
            logger.debug("Grouping component steps for batch group {} into batches", (Object)batchGroup);
            for (int batchStartIndex = 0; batchStartIndex < elements.size(); batchStartIndex += maxBatchSize) {
                int batchEndIndex = Math.min(batchStartIndex + maxBatchSize, elements.size());
                logger.debug("Grouping {} component steps for batch group {} into one batch", (Object)(batchEndIndex - batchStartIndex), (Object)batchGroup);
                List batch = elements.subList(batchStartIndex, batchEndIndex);
                logger.debug("Converting batch elements {} into steps", batch);
                List batchSteps = Lists.transform(batch, (Function)new Function<BatchElement, PowerShellDeploymentStep>(){

                    public PowerShellDeploymentStep apply(BatchElement input) {
                        return input.getStep();
                    }
                });
                logger.debug("Generatting description");
                String description = PowerShellBatchContributor.generateBatchDescription(batchGroup.getVerb(), container, batchSteps);
                logger.debug("Creating batch step with description [{}]", (Object)description);
                PowerShellBatchDeploymentStep batchStep = new PowerShellBatchDeploymentStep(batchGroup.getOrder(), container, batchSteps, description);
                logger.debug("Adding batch step");
                ctx.addStep((Step)batchStep);
                logger.debug("Adding checkpoints");
                for (BatchElement e : batch) {
                    if (e.getDelta() == null) continue;
                    if (e.getOperation() != null) {
                        ctx.addCheckpoint((Step)batchStep, e.getDelta(), e.getOperation());
                        continue;
                    }
                    ctx.addCheckpoint((Step)batchStep, e.getDelta());
                }
            }
        }
    }

    private static String generateBatchDescription(String verb, HostContainer container, List<PowerShellDeploymentStep> steps) {
        StringBuilder descriptionBuilder = new StringBuilder();
        descriptionBuilder.append(verb);
        for (int i = 0; i < steps.size(); ++i) {
            if (descriptionBuilder.length() > 50) {
                descriptionBuilder.append(", ...");
                break;
            }
            descriptionBuilder.append(i > 0 ? ", " : " ");
            descriptionBuilder.append(steps.get((int)i).deployed.getName());
        }
        descriptionBuilder.append(" on ");
        descriptionBuilder.append(container.getName());
        return descriptionBuilder.toString();
    }

    private static Deployed<?, ?> getActiveDeployed(Delta d) {
        if (d.getDeployed() != null) {
            return d.getDeployed();
        }
        return d.getPrevious();
    }

    static class BatchGroup {
        private final int order;
        private final String verb;

        public BatchGroup(int order, String verb) {
            this.order = order;
            this.verb = verb;
        }

        public int getOrder() {
            return this.order;
        }

        public String getVerb() {
            return this.verb;
        }

        public String toString() {
            return String.format("BatchGroup[order = %d, verb = %s]", this.order, this.verb);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.order, this.verb});
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            BatchGroup that = (BatchGroup)o;
            return Objects.equal((Object)this.verb, (Object)that.verb) && Objects.equal((Object)this.order, (Object)that.order);
        }
    }

    static class BatchElement {
        private final PowerShellDeploymentStep step;
        private final Delta delta;
        private final Operation operation;

        public BatchElement(PowerShellDeploymentStep step) {
            this(step, null, null);
        }

        public BatchElement(PowerShellDeploymentStep step, Delta delta, Operation operation) {
            this.step = step;
            this.delta = delta;
            this.operation = operation;
        }

        public PowerShellDeploymentStep getStep() {
            return this.step;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            if (this.delta == null && this.operation == null) {
                return String.format("BatchElement[step = \"%s\"]", this.step.getDescription());
            }
            return String.format("BatchElement[step = \"%s\", delta = %s, operation = %s]", this.step.getDescription(), this.delta, this.operation);
        }
    }
}

