package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.file.FileCopyStrategy;
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base class for all extensible PowerShell deployed artifact configuration items.")
public class ExtensiblePowerShellDeployedArtifact extends BaseExtensiblePowerShellDeployedArtifact<DeployableArtifact> implements DerivedArtifact<DeployableArtifact> {

    @Property(required = false, label="Default Copy Strategy", description = "Default copy strategy for this folder artifact.")
    private FileCopyStrategy defaultCopyStrategy;

    public FileCopyStrategy getDefaultCopyStrategy() {
        return defaultCopyStrategy;
    }

    public void setDefaultCopyStrategy(FileCopyStrategy defaultCopyStrategy) {
        this.defaultCopyStrategy = defaultCopyStrategy;
    }

    public DefaultCopyStrategyName getDefaultCopyStrategyName() {
        return defaultCopyStrategy != null ? defaultCopyStrategy.getProperty("defaultCopyStrategy") : null;
    }
}
