/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.IPythonManagedDeployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PythonManagedDeployed<D extends Deployable, C extends PythonManagedContainer>
extends BaseDeployed<D, C>
implements IPythonManagedDeployed {
    @Property(required=false, hidden=true, description="List of scripts to be appended to the deployed's runtime script")
    private List<String> libraryScripts = Lists.newArrayList();
    @Property(hidden=true, defaultValue="50", description="The order in which a discover step will be executed.")
    private int discoverOrder;
    @Property(required=false, hidden=true, defaultValue="false", description="Flag to indicate whether the deployed application CI is to be injected to the Python script execution context.")
    private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb) {
        return this.addStep(ctx, order, scriptPath, verb, true, null);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb, boolean uploadArtifactData) {
        return this.addStep(ctx, order, scriptPath, verb, uploadArtifactData, null);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb, CheckpointInfo checkpoint) {
        return this.addStep(ctx, order, scriptPath, verb, true, checkpoint);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb, boolean uploadArtifactData, CheckpointInfo checkpoint) {
        if (!Strings.isNullOrEmpty((String)scriptPath)) {
            PythonDeploymentStep step = new PythonDeploymentStep(order, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), scriptPath, this.getPythonVars(ctx.getDeployedApplication()), this.getDescription(verb));
            step.setUploadArtifactData(uploadArtifactData);
            if (checkpoint == null) {
                ctx.addStep((Step)step);
            } else {
                ctx.addStepWithCheckpoint((Step)step, checkpoint.delta, checkpoint.operation);
            }
            return true;
        }
        return false;
    }

    protected boolean addStep(InspectionContext ctx, String scriptPath, String verb) {
        if (!Strings.isNullOrEmpty((String)scriptPath)) {
            ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), scriptPath, this.getPythonVars(null), this.getDescription(verb)));
            return true;
        }
        return false;
    }

    protected Map<String, Object> getPythonVars() {
        return this.getPythonVars(null);
    }

    protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("deployed", this);
        if (this.exposeDeployedApplication) {
            Checks.checkNotNull((Object)deployedApplication, (String)"deployedApplication is null");
            pythonVars.put("deployedApplication", deployedApplication);
        }
        return pythonVars;
    }

    protected String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getName(), ((PythonManagedContainer)this.getContainer()).getName());
    }

    public boolean getExposeDeployedApplication() {
        return this.exposeDeployedApplication;
    }

    public void setExposeDeployedApplication(boolean exposeDeployedApplication) {
        this.exposeDeployedApplication = exposeDeployedApplication;
    }

    @Override
    public List<String> getLibraryScripts() {
        return this.libraryScripts;
    }

    public int getDiscoverOrder() {
        return this.discoverOrder;
    }

    public void setDiscoverOrder(int discoverOrder) {
        this.discoverOrder = discoverOrder;
    }

    protected static CheckpointInfo checkpoint(Delta delta) {
        return new CheckpointInfo(delta);
    }

    protected static CheckpointInfo checkpoint(Delta delta, Operation operation) {
        return new CheckpointInfo(delta, operation);
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch(name, args, (ConfigurationItem)this, this.getContainer());
    }

    protected static class CheckpointInfo {
        public final Delta delta;
        public final Operation operation;

        CheckpointInfo(Delta delta) {
            this.delta = delta;
            this.operation = delta.getOperation();
        }

        CheckpointInfo(Delta delta, Operation operation) {
            this.delta = delta;
            this.operation = operation;
        }
    }
}

