package com.xebialabs.deployit.plugin.trigger;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;

import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public enum StepState implements TriggerState<StepExecutionState> {
    ANY(null,null),
    PENDING(StepExecutionState.PENDING, newHashSet(StepExecutionState.EXECUTING, StepExecutionState.SKIP)),
    SKIP(StepExecutionState.SKIP, newHashSet(StepExecutionState.PENDING, StepExecutionState.SKIPPED)),
    EXECUTING(StepExecutionState.EXECUTING, newHashSet(StepExecutionState.DONE, StepExecutionState.FAILED, StepExecutionState.PAUSED)),
    DONE(StepExecutionState.DONE, Sets.<StepExecutionState>newHashSet()),
    FAILED(StepExecutionState.FAILED, newHashSet(StepExecutionState.SKIP,StepExecutionState.EXECUTING)),
    PAUSED(StepExecutionState.PAUSED, newHashSet(StepExecutionState.EXECUTING, StepExecutionState.SKIP)),
    SKIPPED(StepExecutionState.SKIPPED, Sets.<StepExecutionState>newHashSet());

    private StepExecutionState stepExecutionState;
    private Set<StepExecutionState> validToTransition;

    private StepState(StepExecutionState stepExecutionState, Set<StepExecutionState> validToTransition) {
        this.stepExecutionState = stepExecutionState;
        this.validToTransition = validToTransition;
    }

    public boolean equivalentTo(StepExecutionState spiState) {
        if (spiState == null) {
            return false;
        }
        return (stepExecutionState == null) || (stepExecutionState == spiState);
    }

    public boolean isValidTransition(StepState toState) {
        if (stepExecutionState == null || toState.stepExecutionState == null) {  //ANY state
            return true;
        }

        return validToTransition.contains(toState.stepExecutionState);
    }


}
