package com.xebialabs.deployit.plugin.trigger;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

@SuppressWarnings("serial")
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, description = "Defines actions to executed for the specified state transition of a Task.")
@TriggerValidator
public class TaskTrigger extends Trigger<TaskState> {

    @Property(defaultValue = "ANY", description = "Trigger actions when the Task transitions from this state.")
    private TaskState fromState = TaskState.ANY;

    @Property(description = "Trigger actions when the Task transitions to this state.")
    private TaskState toState;

    @Override
    public TaskState getFromState() {
        return fromState;
    }

    @Override
    public TaskState getToState() {
        return toState;
    }

    public void setFromState(TaskState fromState) {
        this.fromState = fromState;
    }

    public void setToState(TaskState toState) {
        this.toState = toState;
    }
}
