package com.xebialabs.deployit.plugin.trigger;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings({ "serial", "rawtypes" })
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, description = "Trigger with associated actions.")
public abstract class Trigger<T extends TriggerState> extends BaseConfigurationItem {

    @Property(description = "Actions to execute when specified state transition occurs.")
    private List<Action> actions = newArrayList();

    public abstract T getFromState();

    public abstract T getToState();

    public List<Action> getActions() {
        return actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }
}
