/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.trigger.action;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.mail.SmtpServer;
import com.xebialabs.deployit.plugin.trigger.Action;
import com.xebialabs.deployit.plugin.trigger.BodyValidator;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, description="Email Action")
@BodyValidator
public class EmailNotification
extends BaseConfigurationItem
implements Action {
    @Property(description="Mail addresses of recepients.")
    private List<String> toAddresses = Lists.newArrayList();
    @Property(required=false, description="From mail address. Defaults to SMTPServer fromAddress.")
    private String fromAddress;
    @Property(description="Mail subject")
    private String subject;
    @Property(required=false, defaultValue="false", description="Mail body content should be sent as HTML")
    private boolean sendContentAsHtml;
    @Property(required=false, size=Property.Size.LARGE, description="Mail body content in the form of a Freemarker template.")
    private String body;
    @Property(required=false, description="Freemarker template used to render mail body content. Path can be absolute or relative to XL Deploy's classpath.")
    private String bodyTemplatePath;
    @Property(description="The mail server used to send the email.")
    private SmtpServer mailServer;
    private static final Logger logger = LoggerFactory.getLogger(EmailNotification.class);

    @Override
    public void execute(Map<String, Object> ctx) {
        try {
            String msg = Strings.isNullOrEmpty((String)this.body) ? this.renderEmailTemplate(this.bodyTemplatePath, ctx, false) : this.renderEmailTemplate(this.body, ctx, true);
            if (!Strings.isNullOrEmpty((String)msg.trim())) {
                String resolvedSubject = ConfigurationHolder.resolveExpression((String)this.subject, ctx);
                String resolvedFromAddress = Strings.isNullOrEmpty((String)this.fromAddress) ? ConfigurationHolder.resolveExpression((String)this.mailServer.getFromAddress(), ctx) : ConfigurationHolder.resolveExpression((String)this.fromAddress, ctx);
                List resolvedRecipients = ConfigurationHolder.resolveExpression(this.toAddresses, ctx);
                this.mailServer.sendMessage(resolvedSubject, msg, resolvedRecipients, resolvedFromAddress, this.sendContentAsHtml);
            }
        }
        catch (TemplateException e) {
            logger.error("Failed to render email template.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Failed to load email template.", (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error("Failed to send mail.", (Throwable)e);
        }
    }

    protected String renderEmailTemplate(String template, Map<String, Object> vars, boolean inlineTemplate) throws IOException, TemplateException {
        File templateFile;
        Configuration cfg = ConfigurationHolder.getConfiguration();
        Template loadedTemplate = inlineTemplate ? new Template("name", (Reader)new StringReader(template), cfg) : ((templateFile = new File(template)).exists() ? new Template("name", (Reader)new FileReader(template), cfg) : cfg.getTemplate(template));
        StringWriter sw = new StringWriter();
        loadedTemplate.process(vars, (Writer)sw);
        return sw.toString();
    }

    public List<String> getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBodyTemplatePath() {
        return this.bodyTemplatePath;
    }

    public void setBodyTemplatePath(String bodyTemplatePath) {
        this.bodyTemplatePath = bodyTemplatePath;
    }

    public SmtpServer getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(SmtpServer mailServer) {
        this.mailServer = mailServer;
    }

    public boolean isSendContentAsHtml() {
        return this.sendContentAsHtml;
    }

    public void setSendContentAsHtml(boolean sendContentAsHtml) {
        this.sendContentAsHtml = sendContentAsHtml;
    }
}

