package com.xebialabs.deployit.plugin.service

import com.xebialabs.deployit.plugin.api.services.ArtifactTransformer
import com.xebialabs.deployit.plugin.api.services.ArtifactTransformer._
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, DeployedApplication}
import com.xebialabs.deployit.plugin.service.PatchDictionaryTransformer._
import grizzled.slf4j.Logging

import java.io.InputStream
import java.util
import scala.jdk.CollectionConverters._

object PatchDictionaryTransformer {
  val configurationItemKey = "configurationItem"
  val deployedKey = "deployed"
}

class PatchDictionaryTransformer extends ArtifactTransformer with Logging {
  override def transform(source: InputStream, transformationContext: util.Map[String, Any]): InputStream = {
    val deployed = transformationContext.getProperty(deployedKey, { case deployed: DeployedApplication => deployed })
    val ci = transformationContext.getProperty(configurationItemKey, { case configurationItem: ConfigurationItem => configurationItem })

    val patchDictionaries = deployed.getEnvironment.getPatchDictionaries
    logger.debug("Going to apply {} patch dictionaries for DeployedApplication [{}] on Environment [{}]", patchDictionaries.size, deployed, deployed.getEnvironment)
    patchDictionaries.asScala.foldLeft(source)((intermediate, patchDictionary) => patchDictionary.apply(intermediate, ci))
  }
}
