package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

@StepMetadata(name="rule-deployed-step")
public class RuleDeployedStep implements Step {

    @StepParameter(description = "this is a deployed param")
    private String testParam;

    public String getTestParam() {
        return testParam;
    }

    @Override
    public int getOrder() {
        return 10;
    }

    @Override
    public String getDescription() {
        return "My deployed rule test step";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        ctx.logOutput("log output " + testParam);
        return StepExitCode.SUCCESS;
    }
}
