package com.xebialabs.deployit.plugin.test.v3;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.test.v3.step.TestCreateStep;
import com.xebialabs.deployit.plugin.test.v3.step.TestDestroyStep;

@SuppressWarnings("serial")
@Metadata
public class DeployedDummyEarWithAllProperties extends BaseDeployedArtifact<DummyEarWithAllProperties, DummyJeeServer> {

    @Property(required = false)
    private int integerProp;

    @Property(required = false)
    private String stringProp;

    @Property(required = false)
    private boolean booleanProp;

    @Property(required = false)
    private Set<String> setOfStringsProp;
    
    @Property(required=false)
    private DummyEnum enumProp;

    @Create
    public void deploy(DeploymentPlanningContext result) {
        for (int i = 0; i < getContainer().getNumberOfSteps(); i++) {
            result.addStep(new TestCreateStep(getContainer(), i));
        }
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result) {
        destroy(result);
        deploy(result);
    }

    @Destroy
    public void destroy(DeploymentPlanningContext result) {
        for (int i = 0; i < getContainer().getNumberOfSteps(); i++) {
            result.addStep(new TestDestroyStep(getContainer(), i));
        }
    }

    public int getIntegerProp() {
        return integerProp;
    }

    public void setIntegerProp(int integerProp) {
        this.integerProp = integerProp;
    }

    public String getStringProp() {
        return stringProp;
    }

    public void setStringProp(String stringProp) {
        this.stringProp = stringProp;
    }

    public boolean isBooleanProp() {
        return booleanProp;
    }

    public void setBooleanProp(boolean booleanProp) {
        this.booleanProp = booleanProp;
    }

    public Set<String> getSetOfStringsProp() {
        return setOfStringsProp;
    }

    public void setSetOfStringsProp(Set<String> setOfStringsProp) {
        this.setOfStringsProp = setOfStringsProp;
    }

    public DummyEnum getEnumProp() {
        return enumProp;
    }

    public void setEnumProp(DummyEnum enumProp) {
        this.enumProp = enumProp;
    }

}
