package com.xebialabs.deployit.upgrade.sql

import java.util

import com.xebialabs.deployit.server.api.upgrade.{RepoType, RepositoryInitialization}
import com.xebialabs.deployit.upgrade.InitializationStrategy
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class SqlInitializationStrategy extends InitializationStrategy {

  override def findApplicableInitializerTypes(): util.Set[Class[_ <: RepositoryInitialization]] =
    InitializationStrategy.findApplicableInitializerTypes(RepoType.SQL)

  override def doInitializations(initializations: util.List[RepositoryInitialization]): Unit =
    initializations.asScala.sortBy(_.getPriority).foreach(_.doInitialize())
}
