package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.upgrade.service.{ArchiveDirectoryRefUpgraderService, DirectoryRefUpgraderService}
import com.xebialabs.deployit.server.api.upgrade.{RepositoryInitialization, Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class Deployit1030SetSecuredDirectoryReference(@Autowired val directoryRefUpgraderService: DirectoryRefUpgraderService,
                                               @Autowired val archiveDirectoryRefUpgraderService: ArchiveDirectoryRefUpgraderService) extends Upgrade with RepositoryInitialization with Logging {
  override def doUpgrade(): Boolean = Try {
    directoryRefUpgraderService.updateSecuredDirectoryRefs()
    val ciIdToSecuredDirMap = directoryRefUpgraderService.getCiIdSecuredDirectoryReferencesMap()
    archiveDirectoryRefUpgraderService.updateDirectoryRefsForArchivedTables(ciIdToSecuredDirMap)
  } match {
    case Success(_) =>
      logger.debug("Secured_directory_ref updates have been successfully applied.")
      true
    case Failure(exception: Exception) =>
      logger.error("Secured_directory_ref updates cannot be applied.", exception)
      false
  }

  override def upgradeVersion(): Version = Version.valueOf(getComponent, "10.3.0")

  override def doInitialize(): Unit = doUpgrade()

  override def getComponent: String = "deployit"

  override def getPriority: Integer = Int.MaxValue
}
