package com.xebialabs.deployit.core.upgrade.service

import com.xebialabs.deployit.core.sql.spring.DeployJdbcTemplate
import com.xebialabs.deployit.core.sql.{Queries, SchemaInfo, TableName}
import com.xebialabs.deployit.core.upgrade.service.ArchivedControlTasks.archivedControlTasksTable
import com.xebialabs.deployit.core.upgrade.service.ArchivedDeploymentTasks.archiveTasksTable
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.stereotype.Component
import org.springframework.transaction.annotation.Transactional

import javax.sql.DataSource

trait ArchiveDateUpgraderService extends Queries {
  def updateArchiveDateForArchivedTasks()
}

@Component
@Transactional("reportingTransactionManager")
class DefaultArchiveDateUpdagraderService(@Autowired @Qualifier("reportingSchema") val schemaInfo: SchemaInfo,
                                          @Autowired @Qualifier("reportingDataSource") val reportingDataSource: DataSource,
                                         ) extends ArchiveDateUpgraderService with Logging {

  private[this] val reportingJdbcTemplate = new DeployJdbcTemplate(reportingDataSource, false)
  private def updateArchiveDate(tableToUpdate: TableName): Unit = {
    import ArchivedDeploymentTasks._
    logger.info(s"starting archived_date update for table $tableToUpdate")
    reportingJdbcTemplate.update(sqlb"UPDATE $tableToUpdate SET $archive_date = $end_date WHERE $archive_date is null")
    logger.info(s"completed archived_date update for table $tableToUpdate")
  }

  override def updateArchiveDateForArchivedTasks(): Unit = {
    updateArchiveDate(archiveTasksTable)
    updateArchiveDate(archivedControlTasksTable)
  }
}
