package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.sql.spring.transactional
import com.xebialabs.deployit.core.upgrade.service.{LastVersionUpgraderService, SecurityUpgraderService}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.transaction.PlatformTransactionManager

import scala.util.{Failure, Success, Try}

class Deployit1001LastVersionUpgrader(@Autowired val securityUpgraderService: SecurityUpgraderService,
                                      @Autowired val lastVersionUpgraderService: LastVersionUpgraderService,
                                      @Autowired @Qualifier("mainTransactionManager") val transactionManager: PlatformTransactionManager
                                     ) extends Upgrade with Logging {
  override def doUpgrade(): Boolean = doUpdateLastVersions()

  override def upgradeVersion(): Version = Version.valueOf("deployit", "10.0.1")

  private def doUpdateLastVersions(): Boolean = Try {
    transactional(transactionManager) {
      lastVersionUpgraderService.updateLastVersions()
    }

  } match {
    case Success(_) =>
      logger.debug("Last version updates have been successfully applied.")
      true
    case Failure(exception: Exception) =>
      logger.error("Last version updates cannot be applied.", exception)
      false
  }
}
