package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.core.upgrade.service.{UserProfile, UserProfileUpgradeService}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class Deployit2403UserProfileMigrationUpgrader(@Autowired val userProfileUpgradeService: UserProfileUpgradeService)
                                                extends Upgrade with Logging {
  override def doUpgrade(): Boolean =
    Try {
      val externalUserUpdateList = userProfileUpgradeService.fetchExternalUserForUpdate()
      val externalUserInsertList = userProfileUpgradeService.fetchExternalUserForInsert()
      val internalUserUpdateList = userProfileUpgradeService.fetchInternalUserForUpdate()
      val internalUserUpdateMap: Map[String, UserProfile] = internalUserUpdateList.map(user => user.username.toLowerCase -> user).toMap

      userProfileUpgradeService.insertXldUserProfile(externalUserInsertList)
      userProfileUpgradeService.updateXldUserProfile(externalUserUpdateList)
      userProfileUpgradeService.updateXldUserProfile(internalUserUpdateMap.values.toList)

      val internalUserDisplayUsernameUpdateList = userProfileUpgradeService.fetchInternalUsersWithNullDisplayUsername()
      userProfileUpgradeService.updateXldUserProfileDisplayUsername(internalUserDisplayUsernameUpdateList)
    } match {
      case Success(_) =>
        logger.debug("Successfully fetched the external user data.")
        true
      case Failure(exception: Exception) =>
        logger.error("Exception While fetching the external user data.", exception)
        false
    }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "24.3.0")
}
