package com.xebialabs.deployit.core.upgrade

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.{RepositoryService, SearchParameters}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}
import scala.jdk.CollectionConverters._

class Deployit243DeleteWebhookServersUpgrader(@Autowired val repositoryService: RepositoryService)
                                                extends Upgrade with Logging {
  override def doUpgrade(): Boolean = {
    Try(removeExistingWebhookServers()) match {
      case Success(_) =>
        logger.info("Finished deleting existing Webhook Servers")
        true
      case Failure(exception: Exception) =>
        logger.error("Unable to delete existing Webhook Servers: ", exception)
        false
    }
  }

  private def removeExistingWebhookServers(): Unit = {
    val query = new SearchParameters().setType(Type.valueOf("webhook.WebhookServer"))
    val ids = repositoryService.listEntities[ConfigurationItem](query).asScala.map(_.getId).toList
    repositoryService.delete(ids: _*)
  }

  override def upgradeVersion(): Version = Version.valueOf("deployit", "24.3.0")
}
