package com.xebialabs.deployit.upgrade.sql

import java.util

import com.xebialabs.deployit.server.api.upgrade.{RepoType, Upgrade, UpgradeException}
import com.xebialabs.deployit.upgrade.UpgradeStrategy
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class SqlUpgradeStrategy extends UpgradeStrategy {
  override def findApplicableUpgradeTypes(): util.Set[Class[_ <: Upgrade]] = UpgradeStrategy.findApplicableUpgradeTypes(RepoType.SQL)

  override def doUpgrades(upgrades: util.List[Upgrade]): Unit = {
    upgrades.asScala.foreach { upgrade =>
      if (!upgrade.doUpgrade()) {
        throw new UpgradeException(s"Could not perform upgrade [$upgrade] to upgrade to [${upgrade.upgradeVersion()}]")
      }
    }
  }
}
