package ai.digital.deploy.sql.model;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.xml.OmitXmlPreamble;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@XmlRootElement
@OmitXmlPreamble
public class Report {

    private List<ReportLine> lines = Lists.newArrayList();

    @XmlElement(name = "lines")
    public List<ReportLine> getLines() {
        return lines;
    }

    public void setLines(final List<ReportLine> lines) {
        this.lines = lines;
    }

    public ReportLine addLine() {
        final ReportLine reportLine = new ReportLine();
        lines.add(reportLine);
        return reportLine;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Report fromLines(final Stream<ReportLine> taskReportStream) {
        Report report = new Report();
        report.setLines(taskReportStream.collect(Collectors.toList()));
        return report;
    }

}
