package ai.digital.deploy.sql.model;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class ViewAs {
    private String user;
    private List<String> roles;

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public static ViewAs fromViewAsData(ViewAsData data) {
        ViewAs viewAs = new ViewAs();
        if (data != null) {
            if (data.getUser() != null) {
                viewAs.setUser(data.getUser().getPrincipal().toString());
            } else if (data.getRoles() != null) {
                viewAs.setRoles(data.getRoles().stream().map(Role::getName).collect(toList()));
            }
        }
        return viewAs;
    }
}
