package ai.digital.deploy.sql.model

import com.xebialabs.deployit.engine.api.dto.AbstractDto
import javax.xml.bind.annotation.XmlRootElement


/**
  * Has information about currently active user session and it's associated tasks
  */
@XmlRootElement
class ActiveUserSession()
  extends AbstractDto {
  private var username: String = _
  private var internal = false
  private var controlTasks = 0
  private var deploymentTasks = 0

  def this(username: String, internal: Boolean, controlTasks: Int, deploymentTasks: Int) {
    this()
    this.username = username
    this.internal = internal
    this.controlTasks = controlTasks
    this.deploymentTasks = deploymentTasks
  }

  def getUsername: String = username

  def setUsername(username: String): Unit = {
    this.username = username
  }

  def isInternal: Boolean = internal

  def setInternal(internal: Boolean): Unit = {
    this.internal = internal
  }

  def getControlTasks: Int = controlTasks

  def setControlTasks(controlTasks: Int): Unit = {
    this.controlTasks = controlTasks
  }

  def getDeploymentTasks: Int = deploymentTasks

  def setDeploymentTasks(deploymentTasks: Int): Unit = {
    this.deploymentTasks = deploymentTasks
  }

  override def toString: String = "ActiveUserSession{username=" + username +
    ", internal='" + internal + ", controlTasks='" + controlTasks + ", deploymentTasks='" + deploymentTasks + '}'
}
